/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.maven.plugins.quickstart.documentation;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.wildfly.maven.plugins.quickstart.documentation.MetaData;

public class TOCGenerator {
    private final List<String> ignoredDirs;

    public static void main(String[] args) throws IOException {
        Path root = Paths.get(".", new String[0]).normalize();
        new TOCGenerator(Arrays.asList("target", "dist", "template", "guide")).generate(root, "[TOC-quickstart]", Paths.get("README.adoc", new String[0]), false);
    }

    public TOCGenerator(List<String> ignoredDirs) {
        this.ignoredDirs = ignoredDirs;
    }

    public void generate(Path root, String tocMarker, Path targetDoc, boolean includeOpenshift) throws IOException {
        TreeSet<MetaData> allMetaData = new TreeSet<MetaData>(Comparator.comparing(MetaData::getName));
        try (DirectoryStream<Path> dirs = Files.newDirectoryStream(root, entry -> Files.isDirectory(entry, new LinkOption[0]) && !entry.getFileName().toString().startsWith(".") && !this.ignoredDirs.contains(entry.getFileName().toString()));){
            dirs.forEach(path -> {
                if (Files.exists(path.resolve("README.adoc"), new LinkOption[0])) {
                    try {
                        allMetaData.add(MetaData.parseReadme(path));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    System.out.println(String.format("Directory %s doesn't contain README.adoc, skipping", path));
                }
            });
        }
        StringBuffer sb = TOCGenerator.generateTOC(allMetaData, includeOpenshift);
        Path tocFile = root.resolve(targetDoc);
        String tocFileContent = new String(Files.readAllBytes(tocFile), StandardCharsets.UTF_8);
        tocFileContent = tocFileContent.replaceAll("<TOC>[\\s\\S]*<\\/TOC>", "<TOC>\n" + sb.toString() + "\n//</TOC>");
        Files.write(tocFile, tocFileContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static StringBuffer generateTOC(Set<MetaData> metaDataList, boolean includeOpenshift) {
        StringBuffer sb = new StringBuffer();
        if (includeOpenshift) {
            sb.append("[cols=\"1,1,1,2,1,1\", options=\"header\"]\n");
        } else {
            sb.append("[cols=\"1,1,2,1,1\", options=\"header\"]\n");
        }
        sb.append("|===\n");
        if (includeOpenshift) {
            sb.append("| Quickstart Name | Demonstrated Technologies | Openshift Compatible | Description | Experience Level Required | Prerequisites \n");
        } else {
            sb.append("| Quickstart Name | Demonstrated Technologies | Description | Experience Level Required | Prerequisites \n");
        }
        for (MetaData md : metaDataList) {
            sb.append("| ").append("link:").append(md.getName()).append("/README{outfilesuffix}[").append(md.getName()).append("]|").append(md.getTechnologiesAsString()).append(" | ").append(includeOpenshift ? (md.isOpenshift() ? "Yes | " : "No | ") : "").append(md.getSummary()).append(" | ").append(md.getLevel()).append(" | ").append(md.getPrerequisites() == null ? "_none_" : md.getPrerequisites()).append("\n");
        }
        sb.append("|===");
        return sb;
    }
}

