/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.maven.plugins.quickstart.documentation.drupal;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.maven.plugin.logging.Log;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.SitemapEntry;

class DrupalSitemapParser {
    private final InputStream sitemapInputStream;
    private final Log log;

    DrupalSitemapParser(InputStream sitemapInputStream, Log log) {
        this.sitemapInputStream = sitemapInputStream;
        this.log = log;
    }

    List<SitemapEntry> getAllLocationsOfType(String type) {
        ArrayList<SitemapEntry> sitemapEntries = new ArrayList<SitemapEntry>();
        try {
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            XMLEventReader reader = xmlInputFactory.createXMLEventReader(this.sitemapInputStream);
            while (reader.hasNext()) {
                String location;
                XMLEvent event = reader.nextEvent();
                if (!event.isStartElement() || !event.asStartElement().getName().getLocalPart().equals("loc") || !(location = reader.nextEvent().asCharacters().getData().trim()).contains("/" + type)) continue;
                while (!reader.peek().isStartElement() || !reader.peek().asStartElement().getName().getLocalPart().equals("lastmod")) {
                    reader.nextEvent();
                }
                reader.nextEvent();
                String lastmodText = reader.nextEvent().asCharacters().getData();
                sitemapEntries.add(new SitemapEntry(URI.create(location).getPath(), lastmodText));
            }
        }
        catch (XMLStreamException e) {
            this.log.error((Throwable)e);
            return Collections.emptyList();
        }
        return sitemapEntries;
    }
}

