/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.maven.plugins.quickstart.documentation.drupal.json.hal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import dk.nykredit.jackson.dataformat.hal.HALLink;
import dk.nykredit.jackson.dataformat.hal.annotation.EmbeddedResource;
import dk.nykredit.jackson.dataformat.hal.annotation.Link;
import dk.nykredit.jackson.dataformat.hal.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.json.hal.LinkWrapper;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.json.hal.PathWrapper;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.json.hal.Product;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.json.hal.Tag;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.json.hal.TextWithSummaryWrapper;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.json.hal.TextWrapper;
import org.wildfly.maven.plugins.quickstart.documentation.drupal.json.hal.ValueWrapper;

@Resource
public class CodingResource {
    @Link
    private HALLink type;
    @EmbeddedResource(value="%drupalLocation%/rest/relation/node/coding_resource/field_related_product")
    private List<Product> relatedProduct;
    @EmbeddedResource(value="%drupalLocation%/rest/relation/node/coding_resource/field_tags")
    private List<Tag> fieldTags;
    @Link(value="%drupalLocation%/rest/relation/node/coding_resource/field_related_product")
    private List<HALLink> relatedProductLink;
    @Link(value="%drupalLocation%/rest/relation/node/coding_resource/field_tags")
    private List<HALLink> tagsLink;
    private List<PathWrapper> path;
    private List<ValueWrapper> title;
    private List<TextWithSummaryWrapper> body;
    @JsonProperty(value="field_description")
    private List<TextWrapper> description;
    @JsonProperty(value="field_author")
    private List<ValueWrapper> author;
    @JsonProperty(value="field_contributors")
    private List<ValueWrapper> contributors;
    @JsonProperty(value="field_level")
    private List<ValueWrapper> level;
    @JsonProperty(value="field_resource_type")
    private List<ValueWrapper> resourceType;
    @JsonProperty(value="field_version")
    private List<ValueWrapper> version;
    @JsonProperty(value="field_technologies")
    private List<ValueWrapper> technologies;
    @JsonProperty(value="field_source_link")
    private List<LinkWrapper> sourceLink;

    public CodingResource(String path, String title, String body) {
        this.path = Collections.singletonList(new PathWrapper(path));
        this.title = Collections.singletonList(new ValueWrapper(title));
        this.body = Collections.singletonList(new TextWithSummaryWrapper(body, ""));
        this.description = new ArrayList<TextWrapper>();
        this.author = new ArrayList<ValueWrapper>();
        this.contributors = new ArrayList<ValueWrapper>();
        this.resourceType = new ArrayList<ValueWrapper>();
        this.version = new ArrayList<ValueWrapper>();
        this.level = new ArrayList<ValueWrapper>();
        this.technologies = new ArrayList<ValueWrapper>();
        this.sourceLink = new ArrayList<LinkWrapper>();
        this.type = new HALLink.Builder("%drupalLocation%/rest/type/node/coding_resource").build();
        this.relatedProductLink = new ArrayList<HALLink>();
        this.tagsLink = new ArrayList<HALLink>();
        this.relatedProduct = new ArrayList<Product>();
        this.fieldTags = new ArrayList<Tag>();
    }

    public HALLink getType() {
        return this.type;
    }

    public void setType(HALLink type) {
        this.type = type;
    }

    public List<HALLink> getRelatedProductLink() {
        return this.relatedProductLink;
    }

    public void setRelatedProductLink(List<HALLink> relatedProductLink) {
        this.relatedProductLink = relatedProductLink;
    }

    public List<HALLink> getTagsLink() {
        return new ArrayList<HALLink>(this.tagsLink);
    }

    public void setTagsLink(List<HALLink> tagsLink) {
        this.tagsLink = tagsLink;
    }

    public List<PathWrapper> getPath() {
        return new ArrayList<PathWrapper>(this.path);
    }

    @JsonIgnore
    public String getPathValue() {
        if (this.path.isEmpty()) {
            return "";
        }
        return this.path.get(0).getAlias();
    }

    public void addPath(String path) {
        this.path.add(new PathWrapper(path));
    }

    public Collection<ValueWrapper> getTitle() {
        return new ArrayList<ValueWrapper>(this.title);
    }

    @JsonIgnore
    public String getTitleValue() {
        if (this.title.isEmpty()) {
            return "";
        }
        return this.title.get(0).getValue();
    }

    public void addTitle(String title) {
        this.title.add(new ValueWrapper(title));
    }

    public List<TextWrapper> getBody() {
        return new ArrayList<TextWrapper>(this.body);
    }

    @JsonIgnore
    public String getBodyValue() {
        if (this.body.isEmpty()) {
            return "";
        }
        return this.body.get(0).getValue();
    }

    public void addBody(String body) {
        this.body.add(new TextWithSummaryWrapper(body, ""));
    }

    public void addRelatedProduct(Product p) {
        this.relatedProductLink.add(p.getSelf());
        this.relatedProduct.add(p);
    }

    public void addRelatedProduct(String nid, String uuid) {
        Product p = new Product(nid, uuid);
        this.addRelatedProduct(p);
    }

    public void addTag(String tid, String uuid) {
        Tag t = new Tag(uuid, tid);
        this.addTag(t);
    }

    public void addTag(Tag t) {
        this.fieldTags.add(t);
        this.tagsLink.add(t.getSelf());
    }

    public List<Product> getRelatedProduct() {
        return new ArrayList<Product>(this.relatedProduct);
    }

    public List<Tag> getFieldTags() {
        return this.fieldTags;
    }

    public void addDescription(String value) {
        this.description.add(new TextWrapper(value));
    }

    public List<TextWrapper> getDescription() {
        return new ArrayList<TextWrapper>(this.description);
    }

    @JsonIgnore
    public String getDescriptionValue() {
        if (this.description.isEmpty()) {
            return "";
        }
        return this.description.get(0).getValue();
    }

    public void addAuthor(String value) {
        this.author.add(new ValueWrapper(value));
    }

    public List<ValueWrapper> getAuthor() {
        return new ArrayList<ValueWrapper>(this.author);
    }

    @JsonIgnore
    public String getAuthorValue() {
        if (this.author.isEmpty()) {
            return "";
        }
        return this.author.get(0).getValue();
    }

    public void addContibutor(String value) {
        this.contributors.add(new ValueWrapper(value));
    }

    public List<ValueWrapper> getContributors() {
        return new ArrayList<ValueWrapper>(this.contributors);
    }

    @JsonIgnore
    public String getContributorValue() {
        if (this.contributors.isEmpty()) {
            return "";
        }
        return this.contributors.get(0).getValue();
    }

    public void addLevel(String value) {
        this.level.add(new ValueWrapper(value));
    }

    public List<ValueWrapper> getLevel() {
        return new ArrayList<ValueWrapper>(this.level);
    }

    @JsonIgnore
    public String getLevelValue() {
        if (this.level.isEmpty()) {
            return "";
        }
        return this.level.get(0).getValue();
    }

    public void addResourceType(String value) {
        this.resourceType.add(new ValueWrapper(value));
    }

    public List<ValueWrapper> getResourceType() {
        return new ArrayList<ValueWrapper>(this.resourceType);
    }

    @JsonIgnore
    public String getResourceTypeValue() {
        if (this.resourceType.isEmpty()) {
            return "";
        }
        return this.resourceType.get(0).getValue();
    }

    public void addVersion(String value) {
        this.version.add(new ValueWrapper(value));
    }

    public List<ValueWrapper> getVersion() {
        return new ArrayList<ValueWrapper>(this.version);
    }

    @JsonIgnore
    public String getVersionValue() {
        if (this.version.isEmpty()) {
            return "";
        }
        return this.version.get(0).getValue();
    }

    public void addTechnologies(String value) {
        if (this.technologies.size() > 0) {
            String joined = String.join((CharSequence)", ", Arrays.asList(this.technologies.get(0).getValue(), value));
            this.technologies.set(0, new ValueWrapper(joined));
        } else {
            this.technologies.add(new ValueWrapper(value));
        }
    }

    public List<ValueWrapper> getTechnologies() {
        return new ArrayList<ValueWrapper>(this.technologies);
    }

    @JsonIgnore
    public String getTechnologiesValue() {
        if (this.technologies.isEmpty()) {
            return "";
        }
        return this.technologies.get(0).getValue();
    }

    public void addSourceLink(String url, String title) {
        this.sourceLink.add(new LinkWrapper(url, title));
    }

    public List<LinkWrapper> getSourceLink() {
        return new ArrayList<LinkWrapper>(this.sourceLink);
    }

    @JsonIgnore
    public String getSourceValue() {
        if (this.sourceLink.isEmpty()) {
            return "";
        }
        return this.sourceLink.get(0).getUri();
    }
}

