/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.maven.plugins.quickstart.documentation;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Options;
import org.asciidoctor.SafeMode;
import org.asciidoctor.ast.Document;

public class MetaData {
    private final String name;
    private String author;
    private String level;
    private String summary;
    private String targetProduct;
    private String source;
    private String prerequisites;
    private String[] technologies;
    private boolean openshift;

    public static MetaData parseReadme(Path quickstartDir) throws IOException {
        Path path = quickstartDir.resolve("README.adoc");
        try (Asciidoctor asciidoctor = Asciidoctor.Factory.create();){
            Options options = Options.builder().safe(SafeMode.UNSAFE).build();
            Document doc = asciidoctor.loadFile(path.toFile(), options);
            MetaData metaData = new MetaData(quickstartDir.getFileName().toString());
            metaData.setAttributes(doc.getAttributes());
            try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                String line;
                boolean shouldReadAbstract = false;
                while ((line = reader.readLine()) != null) {
                    if (shouldReadAbstract) {
                        metaData.summary = line;
                        break;
                    }
                    if (!"[abstract]".equals(line.trim())) continue;
                    shouldReadAbstract = true;
                }
            }
            MetaData metaData2 = metaData;
            return metaData2;
        }
    }

    private MetaData(String name) {
        this.name = name;
    }

    private void setAttributes(Map<String, Object> attributes) {
        this.author = MetaData.resolveAttribute(attributes, "author");
        this.technologies = MetaData.resolveAttribute(attributes, "technologies", value -> value == null ? new String[]{} : value.toString().split(","));
        this.level = MetaData.resolveAttribute(attributes, "level");
        this.targetProduct = MetaData.resolveAttribute(attributes, "productName");
        this.source = MetaData.resolveAttribute(attributes, "source", value -> value == null ? null : value.toString().trim().replaceAll("<", "").replaceAll(">", ""));
        this.prerequisites = MetaData.resolveAttribute(attributes, "prerequisites");
        this.openshift = MetaData.resolveAttribute(attributes, "openshift", value -> value != null && Boolean.parseBoolean(value.toString()));
    }

    String getTechnologiesAsString() {
        return Arrays.stream(this.technologies).map(String::trim).collect(Collectors.joining(", "));
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getTargetProduct() {
        return this.targetProduct;
    }

    public void setTargetProduct(String targetProduct) {
        this.targetProduct = targetProduct;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getPrerequisites() {
        return this.prerequisites;
    }

    public void setPrerequisites(String prerequisites) {
        this.prerequisites = prerequisites;
    }

    public String[] getTechnologies() {
        return this.technologies;
    }

    public void setTechnologies(String[] technologies) {
        this.technologies = technologies;
    }

    public boolean isOpenshift() {
        return this.openshift;
    }

    private static String resolveAttribute(Map<String, Object> attributes, String key) {
        return MetaData.resolveAttribute(attributes, key, value -> value == null ? null : value.toString().trim());
    }

    private static <T> T resolveAttribute(Map<String, Object> attributes, String key, Function<Object, T> resolver) {
        return resolver.apply(attributes.get(key.toLowerCase(Locale.ROOT)));
    }

    public String toString() {
        return "{name='" + this.name + "', author='" + this.author + "', level='" + this.level + "', summary='" + this.summary + "', targetProduct='" + this.targetProduct + "', source='" + this.source + "', prerequisites='" + this.prerequisites + "', openshift='" + this.openshift + "', technologies=" + Arrays.toString(this.technologies) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaData metaData = (MetaData)o;
        return Objects.equals(this.getName(), metaData.getName()) && Objects.equals(this.getAuthor(), metaData.getAuthor()) && Objects.equals(this.getLevel(), metaData.getLevel()) && Objects.equals(this.getSummary(), metaData.getSummary()) && Objects.equals(this.getTargetProduct(), metaData.getTargetProduct()) && Objects.equals(this.getSource(), metaData.getSource()) && Objects.equals(this.getPrerequisites(), metaData.getPrerequisites()) && Arrays.equals(this.getTechnologies(), metaData.getTechnologies());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getAuthor(), this.getLevel(), this.getSummary(), this.getTargetProduct(), this.getSource(), this.getPrerequisites(), this.getTechnologies());
    }
}

