/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.AnnotationInclusion;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigPart;
import com.github.victools.jsonschema.generator.SchemaGeneratorGeneralConfigPart;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.generator.TypeAttributeOverride;
import com.github.victools.jsonschema.generator.impl.SchemaGeneratorConfigImpl;
import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class SchemaGeneratorConfigBuilder {
    private ObjectMapper objectMapper;
    private final OptionPreset preset;
    private final SchemaVersion schemaVersion;
    private final Map<Option, Boolean> options = new HashMap<Option, Boolean>();
    private final SchemaGeneratorGeneralConfigPart typesInGeneralConfigPart = new SchemaGeneratorGeneralConfigPart();
    private final SchemaGeneratorConfigPart<FieldScope> fieldConfigPart = new SchemaGeneratorConfigPart();
    private final SchemaGeneratorConfigPart<MethodScope> methodConfigPart = new SchemaGeneratorConfigPart();
    private final Map<Class<? extends Annotation>, AnnotationInclusion> annotationInclusionOverrides = new LinkedHashMap<Class<? extends Annotation>, AnnotationInclusion>();

    private static ObjectMapper createDefaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        mapper.getSerializationConfig().with(JsonWriteFeature.WRITE_NUMBERS_AS_STRINGS);
        mapper.setNodeFactory(JsonNodeFactory.withExactBigDecimals(true));
        return mapper;
    }

    @Deprecated
    public SchemaGeneratorConfigBuilder(ObjectMapper objectMapper) {
        this(objectMapper, SchemaVersion.DRAFT_7, OptionPreset.FULL_DOCUMENTATION);
    }

    public SchemaGeneratorConfigBuilder(ObjectMapper objectMapper, SchemaVersion schemaVersion) {
        this(objectMapper, schemaVersion, OptionPreset.FULL_DOCUMENTATION);
    }

    public SchemaGeneratorConfigBuilder(SchemaVersion schemaVersion) {
        this(SchemaGeneratorConfigBuilder.createDefaultObjectMapper(), schemaVersion, OptionPreset.FULL_DOCUMENTATION);
    }

    @Deprecated
    public SchemaGeneratorConfigBuilder(ObjectMapper objectMapper, OptionPreset preset) {
        this(objectMapper, SchemaVersion.DRAFT_7, preset);
    }

    public SchemaGeneratorConfigBuilder(SchemaVersion schemaVersion, OptionPreset preset) {
        this(SchemaGeneratorConfigBuilder.createDefaultObjectMapper(), schemaVersion, preset);
    }

    public SchemaGeneratorConfigBuilder(ObjectMapper objectMapper, SchemaVersion schemaVersion, OptionPreset preset) {
        this.objectMapper = objectMapper;
        this.schemaVersion = schemaVersion;
        this.preset = preset;
    }

    public SchemaGeneratorConfig build() {
        EnumSet<Option> allOptions = EnumSet.allOf(Option.class);
        Set<Option> enabledOptions = EnumSet.allOf(Option.class).stream().filter(option -> this.options.getOrDefault(option, this.preset.isOptionEnabledByDefault((Option)((Object)option)))).collect(Collectors.toSet());
        Map validOptions = allOptions.stream().filter(configuredOption -> enabledOptions.stream().noneMatch(enabledOne -> enabledOne.isOverriding((Option)((Object)configuredOption)))).collect(Collectors.toMap(option -> option, enabledOptions::contains, (first, second) -> first, LinkedHashMap::new));
        validOptions.entrySet().stream().map(setting -> ((Option)((Object)((Object)setting.getKey()))).getModule((Boolean)setting.getValue())).filter(Objects::nonNull).forEach(this::with);
        enabledOptions.retainAll(validOptions.keySet());
        return new SchemaGeneratorConfigImpl(this.objectMapper, this.schemaVersion, enabledOptions, this.typesInGeneralConfigPart, this.fieldConfigPart, this.methodConfigPart, this.annotationInclusionOverrides);
    }

    public SchemaGeneratorGeneralConfigPart forTypesInGeneral() {
        return this.typesInGeneralConfigPart;
    }

    public SchemaGeneratorConfigPart<FieldScope> forFields() {
        return this.fieldConfigPart;
    }

    public SchemaGeneratorConfigPart<MethodScope> forMethods() {
        return this.methodConfigPart;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public Boolean getSetting(Option setting) {
        return this.options.get((Object)setting);
    }

    public SchemaGeneratorConfigBuilder with(Module module) {
        module.applyToConfigBuilder(this);
        return this;
    }

    @Deprecated
    public SchemaGeneratorConfigBuilder with(CustomDefinitionProviderV2 definitionProvider) {
        this.typesInGeneralConfigPart.withCustomDefinitionProvider(definitionProvider);
        return this;
    }

    @Deprecated
    public SchemaGeneratorConfigBuilder with(TypeAttributeOverride override) {
        this.typesInGeneralConfigPart.withTypeAttributeOverride(override);
        return this;
    }

    public SchemaGeneratorConfigBuilder with(Option setting, Option ... moreSettings) {
        return this.setOptionEnabled(setting, moreSettings, true);
    }

    public SchemaGeneratorConfigBuilder without(Option setting, Option ... moreSettings) {
        return this.setOptionEnabled(setting, moreSettings, false);
    }

    private SchemaGeneratorConfigBuilder setOptionEnabled(Option setting, Option[] moreSettings, boolean enabled) {
        this.options.put(setting, enabled);
        if (moreSettings != null) {
            for (Option additionalSetting : moreSettings) {
                this.options.put(additionalSetting, enabled);
            }
        }
        return this;
    }

    public SchemaGeneratorConfigBuilder withAnnotationInclusionOverride(Class<? extends Annotation> annotationType, AnnotationInclusion override) {
        this.annotationInclusionOverrides.put(annotationType, override);
        return this;
    }

    public SchemaGeneratorConfigBuilder withObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }
}

