/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.mcp.server.CompletionManager;
import io.quarkiverse.mcp.server.CompletionResponse;
import io.quarkiverse.mcp.server.RequestId;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.Feature;
import io.quarkiverse.mcp.server.runtime.FeatureArgument;
import io.quarkiverse.mcp.server.runtime.FeatureManagerBase;
import io.quarkiverse.mcp.server.runtime.FeatureMetadata;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.inject.Instance;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class CompletionManagerBase
extends FeatureManagerBase<CompletionResponse, CompletionManager.CompletionInfo>
implements CompletionManager {
    protected final ConcurrentMap<String, CompletionManager.CompletionInfo> completions = new ConcurrentHashMap<String, CompletionManager.CompletionInfo>();

    protected CompletionManagerBase(Vertx vertx, ObjectMapper mapper, ConnectionManager connectionManager, Instance<CurrentIdentityAssociation> currentIdentityAssociation) {
        super(vertx, mapper, connectionManager, currentIdentityAssociation);
    }

    @Override
    public CompletionManager.CompletionDefinition newCompletion(String nameReference) {
        return new CompletionDefinitionImpl(nameReference);
    }

    @Override
    public boolean removeCompletion(Predicate<CompletionManager.CompletionInfo> filter) {
        return this.completions.entrySet().removeIf(e -> filter.test((CompletionManager.CompletionInfo)e.getValue()));
    }

    @Override
    Stream<CompletionManager.CompletionInfo> infoStream() {
        return this.completions.values().stream();
    }

    @Override
    public int size() {
        return this.completions.size();
    }

    @Override
    protected FeatureManagerBase.FeatureInvoker<CompletionResponse> getInvoker(String id) {
        CompletionManager.CompletionInfo completion = (CompletionManager.CompletionInfo)this.completions.get(id);
        if (completion instanceof FeatureManagerBase.FeatureInvoker) {
            FeatureManagerBase.FeatureInvoker fi = (FeatureManagerBase.FeatureInvoker)((Object)completion);
            return fi;
        }
        return null;
    }

    protected abstract Feature feature();

    protected abstract void validateReference(String var1, String var2);

    IllegalArgumentException completionAlreadyExists(String refName, String argName) {
        return new IllegalArgumentException("A completion for [" + refName + "] with agument [" + argName + "] already exits");
    }

    class CompletionDefinitionImpl
    extends FeatureManagerBase.FeatureDefinitionBase<CompletionManager.CompletionInfo, CompletionManager.CompletionArguments, CompletionResponse, CompletionDefinitionImpl>
    implements CompletionManager.CompletionDefinition {
        private String argumentName;

        private CompletionDefinitionImpl(String name) {
            super(name);
            this.setDescription("");
        }

        @Override
        public CompletionManager.CompletionDefinition setArgumentName(String argumentName) {
            this.argumentName = argumentName;
            return this;
        }

        @Override
        public CompletionManager.CompletionInfo register() {
            this.validate();
            CompletionManagerBase.this.validateReference(this.name, this.argumentName);
            CompletionDefinitionInfo ret = new CompletionDefinitionInfo(this.name, this.description, this.fun, this.asyncFun, this.runOnVirtualThread, this.argumentName);
            String key = ret.name() + "_" + ret.argumentName();
            CompletionManager.CompletionInfo existing = CompletionManagerBase.this.completions.putIfAbsent(key, ret);
            if (existing != null) {
                throw CompletionManagerBase.this.completionAlreadyExists(this.name, this.argumentName);
            }
            return ret;
        }
    }

    class CompletionDefinitionInfo
    extends FeatureManagerBase.FeatureDefinitionInfoBase<CompletionManager.CompletionArguments, CompletionResponse>
    implements CompletionManager.CompletionInfo {
        private final String argumentName;

        protected CompletionDefinitionInfo(String name, String description, Function<CompletionManager.CompletionArguments, CompletionResponse> fun, Function<CompletionManager.CompletionArguments, Uni<CompletionResponse>> asyncFun, boolean runOnVirtualThread, String argumentName) {
            super(name, description, fun, asyncFun, runOnVirtualThread);
            this.argumentName = argumentName;
        }

        @Override
        public String argumentName() {
            return this.argumentName;
        }

        @Override
        public JsonObject asJson() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected CompletionManager.CompletionArguments createArguments(ArgumentProviders argumentProviders) {
            return new CompletionManager.CompletionArguments(argumentProviders.args().get(this.argumentName).toString(), argumentProviders.connection(), CompletionManagerBase.this.log(CompletionManagerBase.this.feature().toString().toLowerCase() + ":" + this.name, this.name, argumentProviders), new RequestId(argumentProviders.requestId()));
        }
    }

    class CompletionMethod
    extends FeatureManagerBase.FeatureMetadataInvoker<CompletionResponse>
    implements CompletionManager.CompletionInfo {
        CompletionMethod(FeatureMetadata<CompletionResponse> metadata) {
            super(CompletionManagerBase.this, metadata);
        }

        @Override
        public String name() {
            return this.metadata.info().name();
        }

        @Override
        public String argumentName() {
            return this.metadata.info().arguments().stream().filter(FeatureArgument::isParam).findFirst().orElseThrow().name();
        }

        @Override
        public String description() {
            return this.metadata.info().description();
        }

        @Override
        public boolean isMethod() {
            return true;
        }

        @Override
        public JsonObject asJson() {
            throw new UnsupportedOperationException();
        }
    }
}

