/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.runtime.McpConnectionBase;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

@Singleton
public class ConnectionManager
implements Iterable<McpConnectionBase> {
    @Inject
    Vertx vertx;
    private final ConcurrentMap<String, ConnectionTimerId> connections = new ConcurrentHashMap<String, ConnectionTimerId>();
    private final AtomicInteger idGenerator = new AtomicInteger();

    @Override
    public Iterator<McpConnectionBase> iterator() {
        return this.connections.values().stream().map(ConnectionTimerId::connection).iterator();
    }

    public McpConnectionBase get(String id) {
        ConnectionTimerId connectionTimerId = (ConnectionTimerId)this.connections.get(id);
        return connectionTimerId != null ? connectionTimerId.connection() : null;
    }

    public void add(final McpConnectionBase connection) {
        Long timerId = null;
        if (connection.autoPingInterval().isPresent()) {
            timerId = this.vertx.setPeriodic(connection.autoPingInterval().get().toMillis(), new Handler<Long>(){

                @Override
                public void handle(Long timerId) {
                    connection.send(Messages.newPing(ConnectionManager.this.idGenerator.incrementAndGet()));
                }
            });
        }
        this.connections.put(connection.id(), new ConnectionTimerId(connection, timerId));
    }

    public boolean remove(String id) {
        ConnectionTimerId connection = (ConnectionTimerId)this.connections.remove(id);
        if (connection != null) {
            if (connection.timerId() != null) {
                this.vertx.cancelTimer(connection.timerId());
            }
            return true;
        }
        return false;
    }

    record ConnectionTimerId(McpConnectionBase connection, Long timerId) {
    }
}

