/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.Encoder;
import io.quarkiverse.mcp.server.runtime.EncoderMapper;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkus.arc.All;
import io.smallrye.mutiny.Uni;
import java.util.List;

abstract class EncoderResultMapper<ENCODED, ENCODER extends Encoder<?, ENCODED>, RESPONSE>
implements EncoderMapper<Object, RESPONSE> {
    @All
    List<ENCODER> encoders;
    final EncoderMapper<Uni<Object>, RESPONSE> uni = new EncoderMapper<Uni<Object>, RESPONSE>(){

        @Override
        public Uni<RESPONSE> apply(Uni<Object> uni) {
            return uni.map(o -> EncoderResultMapper.this.toResponse(EncoderResultMapper.this.convert(o)));
        }
    };

    protected EncoderResultMapper() {
    }

    @Override
    public Uni<RESPONSE> apply(Object obj) {
        return Uni.createFrom().item(this.toResponse(this.convert(obj)));
    }

    public EncoderMapper<Uni<Object>, RESPONSE> uni() {
        return this.uni;
    }

    protected abstract RESPONSE toResponse(ENCODED var1);

    protected ENCODED convert(Object obj) {
        Class<?> type = obj.getClass();
        for (Encoder encoder : this.encoders) {
            Object encoded;
            if (!encoder.supports(type)) continue;
            try {
                encoded = encoder.encode(EncoderResultMapper.cast(obj));
            }
            catch (Exception e) {
                throw new McpException("Unable to encode object of type " + String.valueOf(type) + " with " + encoder.getClass().getName(), e, -32603);
            }
            return encoded;
        }
        return this.encoderNotFound(obj);
    }

    protected ENCODED encoderNotFound(Object obj) {
        throw new McpException("No encoder found for " + String.valueOf(obj.getClass()), -32603);
    }

    static <T> T cast(Object obj) {
        return (T)obj;
    }
}

