/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.mcp.server.FeatureManager;
import io.quarkiverse.mcp.server.McpLog;
import io.quarkiverse.mcp.server.RequestId;
import io.quarkiverse.mcp.server.RequestUri;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.Cursor;
import io.quarkiverse.mcp.server.runtime.ExecutionModel;
import io.quarkiverse.mcp.server.runtime.FeatureArgument;
import io.quarkiverse.mcp.server.runtime.FeatureMetadata;
import io.quarkiverse.mcp.server.runtime.McpConnectionBase;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.McpLogImpl;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.Page;
import io.quarkiverse.mcp.server.runtime.SecuritySupport;
import io.quarkiverse.mcp.server.runtime.Types;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.quarkus.virtual.threads.VirtualThreadsRecorder;
import io.smallrye.common.vertx.VertxContext;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.invoke.Invoker;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class FeatureManagerBase<RESULT, INFO extends FeatureManager.FeatureInfo> {
    protected final Vertx vertx;
    protected final ObjectMapper mapper;
    protected final ConnectionManager connectionManager;
    protected final ConcurrentMap<String, McpLogImpl> logs;
    protected final CurrentIdentityAssociation currentIdentityAssociation;

    protected FeatureManagerBase(Vertx vertx, ObjectMapper mapper, ConnectionManager connectionManager, Instance<CurrentIdentityAssociation> currentIdentityAssociation) {
        this.vertx = vertx;
        this.mapper = mapper;
        this.connectionManager = connectionManager;
        this.logs = new ConcurrentHashMap<String, McpLogImpl>();
        this.currentIdentityAssociation = currentIdentityAssociation.isResolvable() ? (CurrentIdentityAssociation)currentIdentityAssociation.get() : null;
    }

    public Future<RESULT> execute(String id, final FeatureExecutionContext executionContext) throws McpException {
        final FeatureInvoker<RESULT> invoker = this.getInvoker(id);
        if (invoker != null) {
            return this.execute(invoker.executionModel(), executionContext, new Callable<Uni<RESULT>>(){

                @Override
                public Uni<RESULT> call() throws Exception {
                    return invoker.call(executionContext.argProviders());
                }
            });
        }
        throw this.notFound(id);
    }

    protected Object wrapResult(Object ret, FeatureMetadata<?> metadata, ArgumentProviders argProviders) {
        return ret;
    }

    public Iterator<INFO> iterator() {
        return this.infoStream().sorted().iterator();
    }

    public Page<INFO> fetchPage(Cursor cursor, int pageSize) {
        if (this.isEmpty()) {
            return Page.empty();
        }
        if (this.size() <= pageSize) {
            return new Page<INFO>(this.infoStream().sorted().toList(), true);
        }
        List<FeatureManager.FeatureInfo> result = this.infoStream().filter(r -> r.createdAt().isAfter(cursor.createdAt()) && (cursor.name() == null || r.name().compareTo(cursor.name()) > 0)).sorted().limit(pageSize + 1).toList();
        if (result.size() > pageSize) {
            return new Page<FeatureManager.FeatureInfo>(result.subList(0, result.size() - 1), false);
        }
        return new Page<FeatureManager.FeatureInfo>(result, true);
    }

    abstract Stream<INFO> infoStream();

    public abstract int size();

    public boolean isEmpty() {
        return this.size() < 1;
    }

    protected Object[] prepareArguments(FeatureMetadata<?> metadata, ArgumentProviders argProviders) throws McpException {
        if (metadata.info().arguments().isEmpty()) {
            return new Object[0];
        }
        Object[] ret = new Object[metadata.info().arguments().size()];
        int idx = 0;
        for (FeatureArgument arg : metadata.info().arguments()) {
            if (arg.provider() == FeatureArgument.Provider.MCP_CONNECTION) {
                ret[idx] = argProviders.connection();
            } else if (arg.provider() == FeatureArgument.Provider.REQUEST_ID) {
                ret[idx] = new RequestId(argProviders.requestId());
            } else if (arg.provider() == FeatureArgument.Provider.REQUEST_URI) {
                ret[idx] = new RequestUri(argProviders.uri());
            } else if (arg.provider() == FeatureArgument.Provider.MCP_LOG) {
                ret[idx] = this.log(this.logKey(metadata), metadata.info().declaringClassName(), argProviders);
            } else {
                Object val = argProviders.getArg(arg.name());
                if (val == null && arg.required()) {
                    throw new McpException("Missing required argument: " + arg.name(), -32602);
                }
                if (Types.isOptional(arg.type())) {
                    ret[idx] = Optional.ofNullable(val);
                } else if (val instanceof Map) {
                    Map map = (Map)val;
                    javaType = this.mapper.getTypeFactory().constructType(arg.type());
                    try {
                        ret[idx] = this.mapper.readValue(new JsonObject(map).encode(), javaType);
                    }
                    catch (JsonProcessingException e) {
                        throw new IllegalStateException(e);
                    }
                } else if (val instanceof List) {
                    List list = (List)val;
                    javaType = this.mapper.getTypeFactory().constructType(arg.type());
                    try {
                        ret[idx] = this.mapper.readValue(new JsonArray(list).encode(), javaType);
                    }
                    catch (JsonProcessingException e) {
                        throw new IllegalStateException(e);
                    }
                } else {
                    Class clazz;
                    Type type = arg.type();
                    ret[idx] = type instanceof Class && (clazz = (Class)type).isEnum() ? Enum.valueOf(clazz, val.toString()) : val;
                }
            }
            ++idx;
        }
        return ret;
    }

    protected abstract FeatureInvoker<RESULT> getInvoker(String var1);

    protected abstract McpException notFound(String var1);

    protected Future<RESULT> execute(ExecutionModel executionModel, FeatureExecutionContext executionContext, Callable<Uni<RESULT>> action) {
        final Promise ret = Promise.promise();
        final ActivationSupport activation = new ActivationSupport(action, executionContext.securitySupport());
        Context context = VertxContext.getOrCreateDuplicatedContext(this.vertx);
        VertxContextSafetyToggle.setContextSafe(context, true);
        if (executionModel == ExecutionModel.VIRTUAL_THREAD) {
            context.runOnContext(new Handler<Void>(){

                @Override
                public void handle(Void event) {
                    VirtualThreadsRecorder.getCurrent().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                activation.call().subscribe().with(ret::complete, ret::fail);
                            }
                            catch (Throwable e) {
                                ret.fail(e);
                            }
                        }
                    });
                }
            });
        } else if (executionModel == ExecutionModel.WORKER_THREAD) {
            context.executeBlocking(new Callable<Void>(){

                @Override
                public Void call() {
                    try {
                        activation.call().subscribe().with(ret::complete, ret::fail);
                    }
                    catch (Throwable e) {
                        ret.fail(e);
                    }
                    return null;
                }
            }, false);
        } else {
            context.runOnContext(new Handler<Void>(){

                @Override
                public void handle(Void event) {
                    try {
                        activation.call().subscribe().with(ret::complete, ret::fail);
                    }
                    catch (Throwable e) {
                        ret.fail(e);
                    }
                }
            });
        }
        return ret.future();
    }

    protected McpLog log(String key, String loggerName, ArgumentProviders argProviders) {
        return this.logs.computeIfAbsent(key, k -> new McpLogImpl(argProviders.connection()::logLevel, loggerName, key, argProviders.responder()));
    }

    private String logKey(FeatureMetadata<?> metadata) {
        return metadata.feature().toString().toLowerCase() + ":" + metadata.info().name();
    }

    protected void notifyConnections(String method) {
        for (McpConnectionBase c : this.connectionManager) {
            c.send(Messages.newNotification(method));
        }
    }

    static interface FeatureInvoker<R> {
        public ExecutionModel executionModel();

        public Uni<R> call(ArgumentProviders var1);
    }

    record FeatureExecutionContext(ArgumentProviders argProviders, SecuritySupport securitySupport) {
    }

    private class ActivationSupport<T>
    implements Callable<Uni<T>> {
        private final Callable<Uni<T>> delegate;
        private final SecuritySupport securitySupport;

        private ActivationSupport(Callable<Uni<T>> delegate, SecuritySupport securitySupport) {
            this.delegate = delegate;
            this.securitySupport = securitySupport;
        }

        @Override
        public Uni<T> call() throws Exception {
            ManagedContext requestContext = Arc.container().requestContext();
            if (requestContext.isActive()) {
                if (this.securitySupport != null && FeatureManagerBase.this.currentIdentityAssociation != null) {
                    this.securitySupport.setCurrentIdentity(FeatureManagerBase.this.currentIdentityAssociation);
                }
                return this.delegate.call();
            }
            requestContext.activate();
            if (this.securitySupport != null && FeatureManagerBase.this.currentIdentityAssociation != null) {
                this.securitySupport.setCurrentIdentity(FeatureManagerBase.this.currentIdentityAssociation);
            }
            try {
                return this.delegate.call().eventually(requestContext::terminate);
            }
            catch (Throwable e) {
                requestContext.terminate();
                throw e;
            }
        }
    }

    protected static abstract class FeatureDefinitionInfoBase<ARGUMENTS, RESPONSE>
    implements FeatureManager.FeatureInfo,
    FeatureInvoker<RESPONSE> {
        protected final String name;
        protected final String description;
        protected final Instant createdAt;
        protected final Function<ARGUMENTS, RESPONSE> fun;
        protected final Function<ARGUMENTS, Uni<RESPONSE>> asyncFun;
        protected final boolean runOnVirtualThread;

        protected FeatureDefinitionInfoBase(String name, String description, Function<ARGUMENTS, RESPONSE> fun, Function<ARGUMENTS, Uni<RESPONSE>> asyncFun, boolean runOnVirtualThread) {
            this.name = name;
            this.description = description;
            this.createdAt = Instant.now();
            this.fun = fun;
            this.asyncFun = asyncFun;
            this.runOnVirtualThread = runOnVirtualThread;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String description() {
            return this.description;
        }

        @Override
        public boolean isMethod() {
            return false;
        }

        @Override
        public Instant createdAt() {
            return this.createdAt;
        }

        @Override
        public ExecutionModel executionModel() {
            if (this.runOnVirtualThread) {
                return ExecutionModel.VIRTUAL_THREAD;
            }
            return this.fun != null ? ExecutionModel.WORKER_THREAD : ExecutionModel.EVENT_LOOP;
        }

        protected abstract ARGUMENTS createArguments(ArgumentProviders var1);

        @Override
        public Uni<RESPONSE> call(ArgumentProviders argumentProviders) {
            ARGUMENTS args = this.createArguments(argumentProviders);
            Uni<RESPONSE> ret = this.fun != null ? Uni.createFrom().item(this.fun.apply(args)) : this.asyncFun.apply(args);
            return ret;
        }
    }

    protected static abstract class FeatureDefinitionBase<INFO extends FeatureManager.FeatureInfo, ARGUMENTS, RESPONSE, THIS extends FeatureDefinitionBase<INFO, ARGUMENTS, RESPONSE, THIS>> {
        protected final String name;
        protected String description;
        protected Function<ARGUMENTS, RESPONSE> fun;
        protected Function<ARGUMENTS, Uni<RESPONSE>> asyncFun;
        protected boolean runOnVirtualThread;

        protected FeatureDefinitionBase(String name) {
            this.name = Objects.requireNonNull(name);
        }

        protected THIS self() {
            return (THIS)this;
        }

        public THIS setDescription(String description) {
            this.description = Objects.requireNonNull(description);
            return this.self();
        }

        public THIS setHandler(Function<ARGUMENTS, RESPONSE> fun, boolean runOnVirtualThread) {
            this.fun = Objects.requireNonNull(fun);
            this.runOnVirtualThread = runOnVirtualThread;
            return this.self();
        }

        public THIS setAsyncHandler(Function<ARGUMENTS, Uni<RESPONSE>> asyncFun) {
            this.asyncFun = Objects.requireNonNull(asyncFun);
            return this.self();
        }

        protected void validate() {
            if (this.fun == null && this.asyncFun == null) {
                throw new IllegalStateException("Either sync or async logic must be set");
            }
            if (this.name == null) {
                throw new IllegalStateException("Name must be set");
            }
            if (this.description == null) {
                throw new IllegalStateException("Description must be set");
            }
        }
    }

    class FeatureMetadataInvoker<RESPONSE>
    implements FeatureInvoker<RESPONSE> {
        protected final FeatureMetadata<RESPONSE> metadata;
        private final Instant createdAt;

        FeatureMetadataInvoker(FeatureMetadata<RESPONSE> metadata) {
            this.metadata = metadata;
            this.createdAt = Instant.now();
        }

        @Override
        public ExecutionModel executionModel() {
            return this.metadata.executionModel();
        }

        public Instant createdAt() {
            return this.createdAt;
        }

        @Override
        public Uni<RESPONSE> call(ArgumentProviders argProviders) {
            Invoker<Object, Object> invoker = this.metadata.invoker();
            Object[] arguments = FeatureManagerBase.this.prepareArguments(this.metadata, argProviders);
            try {
                Function<Object, Uni<RESPONSE>> resultMapper = this.metadata.resultMapper();
                Object ret = invoker.invoke(null, arguments);
                ret = FeatureManagerBase.this.wrapResult(ret, this.metadata, argProviders);
                return resultMapper.apply(ret);
            }
            catch (Throwable e) {
                return Uni.createFrom().failure(e);
            }
        }
    }
}

