/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.runtime.ExecutionModel;
import io.quarkiverse.mcp.server.runtime.Feature;
import io.quarkiverse.mcp.server.runtime.FeatureArgument;
import io.quarkiverse.mcp.server.runtime.FeatureMethodInfo;
import io.smallrye.mutiny.Uni;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.invoke.Invoker;
import java.util.function.Function;

public record FeatureMetadata<M>(Feature feature, FeatureMethodInfo info, Invoker<Object, Object> invoker, ExecutionModel executionModel, Function<Object, Uni<M>> resultMapper) implements Comparable<FeatureMetadata<M>>
{
    @Override
    public int compareTo(FeatureMetadata<M> o) {
        return this.info.name().compareTo(o.info.name());
    }

    public JsonObject asJson() {
        JsonObject ret = new JsonObject().put("name", this.info.name()).put("description", this.info.description());
        if (this.feature == Feature.PROMPT) {
            JsonArray arguments = new JsonArray();
            for (FeatureArgument arg : this.info.serializedArguments()) {
                arguments.add(arg.asJson());
            }
            ret.put("arguments", arguments);
        } else if (this.feature == Feature.RESOURCE) {
            ret.put("uri", this.info.uri());
            if (this.info.mimeType() != null) {
                ret.put("mimeType", this.info.mimeType());
            }
        } else if (this.feature == Feature.RESOURCE_TEMPLATE) {
            ret.put("uriTemplate", this.info.uri());
            if (this.info.mimeType() != null) {
                ret.put("mimeType", this.info.mimeType());
            }
        }
        return ret;
    }
}

