/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.mcp.server.ResourceContents;
import io.quarkiverse.mcp.server.ResourceContentsEncoder;
import io.quarkiverse.mcp.server.TextResourceContents;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;

@Singleton
@Priority(value=0)
public class JsonTextResourceContentsEncoder
implements ResourceContentsEncoder<Object> {
    @Inject
    ObjectMapper mapper;

    @Override
    public boolean supports(Class<?> runtimeType) {
        return true;
    }

    @Override
    public ResourceContents encode(ResourceContentsEncoder.ResourceContentsData<Object> data) {
        try {
            return TextResourceContents.create(data.uri().value(), this.mapper.writeValueAsString(data.data()));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }
}

