/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.InitialRequest;
import io.quarkiverse.mcp.server.McpConnection;
import io.quarkiverse.mcp.server.McpLog;
import io.quarkiverse.mcp.server.runtime.Responder;
import io.quarkiverse.mcp.server.runtime.TrafficLogger;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public abstract class McpConnectionBase
implements McpConnection,
Responder {
    protected final String id;
    protected final AtomicReference<McpConnection.Status> status;
    protected final AtomicReference<InitialRequest> initializeRequest;
    protected final AtomicReference<McpLog.LogLevel> logLevel;
    protected final TrafficLogger trafficLogger;
    protected final Optional<Duration> autoPingInterval;

    protected McpConnectionBase(String id, McpLog.LogLevel defaultLogLevel, TrafficLogger trafficLogger, Optional<Duration> autoPingInterval) {
        this.id = id;
        this.status = new AtomicReference<McpConnection.Status>(McpConnection.Status.NEW);
        this.initializeRequest = new AtomicReference();
        this.logLevel = new AtomicReference<McpLog.LogLevel>(defaultLogLevel);
        this.trafficLogger = trafficLogger;
        this.autoPingInterval = autoPingInterval;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public McpConnection.Status status() {
        return this.status.get();
    }

    @Override
    public InitialRequest initialRequest() {
        return this.initializeRequest.get();
    }

    public boolean initialize(InitialRequest request) {
        if (this.status.compareAndSet(McpConnection.Status.NEW, McpConnection.Status.INITIALIZING)) {
            this.initializeRequest.set(request);
            return true;
        }
        return false;
    }

    @Override
    public McpLog.LogLevel logLevel() {
        return this.logLevel.get();
    }

    void setLogLevel(McpLog.LogLevel level) {
        this.logLevel.set(level);
    }

    public boolean setInitialized() {
        return this.status.compareAndSet(McpConnection.Status.INITIALIZING, McpConnection.Status.IN_OPERATION);
    }

    public TrafficLogger trafficLogger() {
        return this.trafficLogger;
    }

    public Optional<Duration> autoPingInterval() {
        return this.autoPingInterval;
    }
}

