/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.McpLog;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.Responder;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

class McpLogImpl
implements McpLog {
    private final String mcpLoggerName;
    private final Supplier<McpLog.LogLevel> level;
    private final Logger log;
    private final Responder responder;

    McpLogImpl(Supplier<McpLog.LogLevel> level, String loggerName, String mcpLoggerName, Responder responder) {
        this.mcpLoggerName = mcpLoggerName;
        this.level = level;
        this.log = Logger.getLogger(loggerName);
        this.responder = responder;
    }

    @Override
    public void send(McpLog.LogLevel level, Object data) {
        if (this.isEnabled(Objects.requireNonNull(level))) {
            this.responder.send(Messages.newNotification("notifications/message", this.newLog(level, this.mcpLoggerName, this.encode(data))));
        }
    }

    @Override
    public void send(McpLog.LogLevel level, String format, Object ... params) {
        if (this.isEnabled(Objects.requireNonNull(level))) {
            this.responder.send(Messages.newNotification("notifications/message", this.newLog(level, this.mcpLoggerName, format.formatted(params))));
        }
    }

    @Override
    public McpLog.LogLevel level() {
        return this.level.get();
    }

    @Override
    public void info(String format, Object ... params) {
        this.log.infof(format, params);
        this.send(McpLog.LogLevel.INFO, format, params);
    }

    @Override
    public void debug(String format, Object ... params) {
        this.log.debugf(format, params);
        this.send(McpLog.LogLevel.DEBUG, format, params);
    }

    @Override
    public void error(String format, Object ... params) {
        this.log.errorf(format, params);
        this.send(McpLog.LogLevel.ERROR, format, params);
    }

    @Override
    public void error(Throwable t, String format, Object ... params) {
        this.log.infof(t, format, params);
        this.send(McpLog.LogLevel.ERROR, format, params);
    }

    private boolean isEnabled(McpLog.LogLevel level) {
        return this.level().ordinal() <= level.ordinal();
    }

    private Object encode(Object data) {
        if (data instanceof JsonObject || data instanceof JsonArray || data instanceof String) {
            return data;
        }
        return Json.encode(data);
    }

    private JsonObject newLog(McpLog.LogLevel level, String loggerName, Object data) {
        return new JsonObject().put("level", level.toString().toLowerCase()).put("logger", loggerName).put("data", data);
    }
}

