/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.ClientCapability;
import io.quarkiverse.mcp.server.Implementation;
import io.quarkiverse.mcp.server.InitialRequest;
import io.quarkiverse.mcp.server.McpConnection;
import io.quarkiverse.mcp.server.McpLog;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.McpConnectionBase;
import io.quarkiverse.mcp.server.runtime.McpMetadata;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.PromptCompleteMessageHandler;
import io.quarkiverse.mcp.server.runtime.PromptCompletionManagerImpl;
import io.quarkiverse.mcp.server.runtime.PromptManagerImpl;
import io.quarkiverse.mcp.server.runtime.PromptMessageHandler;
import io.quarkiverse.mcp.server.runtime.ResourceManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceMessageHandler;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateCompleteManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateCompleteMessageHandler;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateMessageHandler;
import io.quarkiverse.mcp.server.runtime.Responder;
import io.quarkiverse.mcp.server.runtime.SecuritySupport;
import io.quarkiverse.mcp.server.runtime.ToolManagerImpl;
import io.quarkiverse.mcp.server.runtime.ToolMessageHandler;
import io.quarkiverse.mcp.server.runtime.config.McpRuntimeConfig;
import io.quarkus.runtime.LaunchMode;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class McpMessageHandler {
    private static final Logger LOG = Logger.getLogger(McpMessageHandler.class);
    protected final ConnectionManager connectionManager;
    private final ToolMessageHandler toolHandler;
    private final PromptMessageHandler promptHandler;
    private final PromptCompleteMessageHandler promptCompleteHandler;
    private final ResourceMessageHandler resourceHandler;
    private final ResourceTemplateMessageHandler resourceTemplateHandler;
    private final ResourceTemplateCompleteMessageHandler resourceTemplateCompleteHandler;
    protected final McpRuntimeConfig config;
    private final Map<String, Object> serverInfo;
    static final String INITIALIZE = "initialize";
    static final String NOTIFICATIONS_INITIALIZED = "notifications/initialized";
    static final String NOTIFICATIONS_MESSAGE = "notifications/message";
    static final String PROMPTS_LIST = "prompts/list";
    static final String PROMPTS_GET = "prompts/get";
    static final String TOOLS_LIST = "tools/list";
    static final String TOOLS_CALL = "tools/call";
    static final String RESOURCES_LIST = "resources/list";
    static final String RESOURCE_TEMPLATES_LIST = "resources/templates/list";
    static final String RESOURCES_READ = "resources/read";
    static final String RESOURCES_SUBSCRIBE = "resources/subscribe";
    static final String RESOURCES_UNSUBSCRIBE = "resources/unsubscribe";
    static final String PING = "ping";
    static final String COMPLETION_COMPLETE = "completion/complete";
    static final String LOGGING_SET_LEVEL = "logging/setLevel";
    static final String Q_CLOSE = "q/close";
    private static final String DEFAULT_PROTOCOL_VERSION = "2024-11-05";

    protected McpMessageHandler(McpRuntimeConfig config, ConnectionManager connectionManager, PromptManagerImpl promptManager, ToolManagerImpl toolManager, ResourceManagerImpl resourceManager, PromptCompletionManagerImpl promptCompleteManager, ResourceTemplateManagerImpl resourceTemplateManager, ResourceTemplateCompleteManagerImpl resourceTemplateCompleteManager, McpMetadata metadata) {
        this.connectionManager = connectionManager;
        this.toolHandler = new ToolMessageHandler(toolManager, config.tools().pageSize());
        this.promptHandler = new PromptMessageHandler(promptManager, config.prompts().pageSize());
        this.promptCompleteHandler = new PromptCompleteMessageHandler(promptCompleteManager);
        this.resourceHandler = new ResourceMessageHandler(resourceManager, config.resources().pageSize());
        this.resourceTemplateHandler = new ResourceTemplateMessageHandler(resourceTemplateManager, config.resourceTemplates().pageSize());
        this.resourceTemplateCompleteHandler = new ResourceTemplateCompleteMessageHandler(resourceTemplateCompleteManager);
        this.config = config;
        this.serverInfo = this.serverInfo(promptManager, toolManager, resourceManager, resourceTemplateManager, metadata);
    }

    public void handle(JsonObject message, McpConnectionBase connection, Responder responder, SecuritySupport securitySupport) {
        if (Messages.isResponse(message)) {
            LOG.debugf("Discard client response: %s", (Object)message);
        } else {
            switch (connection.status()) {
                case NEW: {
                    this.initializeNew(message, responder, connection, securitySupport);
                    break;
                }
                case INITIALIZING: {
                    this.initializing(message, responder, connection);
                    break;
                }
                case IN_OPERATION: {
                    this.operation(message, responder, connection, securitySupport);
                    break;
                }
                case SHUTDOWN: {
                    responder.send(Messages.newError(message.getValue("id"), -32603, "Connection was already shut down"));
                }
            }
        }
    }

    private void initializeNew(JsonObject message, Responder responder, McpConnectionBase connection, SecuritySupport securitySupport) {
        Object id = message.getValue("id");
        String method = message.getString("method");
        if (!INITIALIZE.equals(method)) {
            InitialRequest dummy;
            if (LaunchMode.current() == LaunchMode.DEVELOPMENT && this.config.devMode().dummyInit() && connection.initialize(dummy = new InitialRequest(new Implementation("dummy", "1"), DEFAULT_PROTOCOL_VERSION, List.of())) && connection.setInitialized()) {
                LOG.infof("Connection initialized with dummy info [%s]", (Object)connection.id());
                this.operation(message, responder, connection, securitySupport);
                return;
            }
            responder.sendError(id, -32601, "The first message from the client must be \"initialize\": " + method);
            return;
        }
        JsonObject params = message.getJsonObject("params");
        if (params == null) {
            responder.sendError(id, -32602, "Initialization params not found");
            return;
        }
        if (connection.initialize(this.decodeInitializeRequest(params))) {
            responder.sendResult(id, this.serverInfo);
        } else {
            responder.sendError(id, -32603, "Unable to initialize connection [connectionId: " + connection.id() + "]");
        }
    }

    private void initializing(JsonObject message, Responder responder, McpConnectionBase connection) {
        String method = message.getString("method");
        if (NOTIFICATIONS_INITIALIZED.equals(method)) {
            if (connection.setInitialized()) {
                LOG.debugf("Client successfully initialized [%s]", (Object)connection.id());
            }
        } else if (PING.equals(method)) {
            this.ping(message, responder);
        } else {
            responder.send(Messages.newError(message.getValue("id"), -32603, "Client not initialized yet [" + connection.id() + "]"));
        }
    }

    private void operation(JsonObject message, Responder responder, McpConnection connection, SecuritySupport securitySupport) {
        String method;
        switch (method = message.getString("method")) {
            case "prompts/list": {
                this.promptHandler.promptsList(message, responder);
                break;
            }
            case "prompts/get": {
                this.promptHandler.promptsGet(message, responder, connection, securitySupport);
                break;
            }
            case "tools/list": {
                this.toolHandler.toolsList(message, responder);
                break;
            }
            case "tools/call": {
                this.toolHandler.toolsCall(message, responder, connection, securitySupport);
                break;
            }
            case "ping": {
                this.ping(message, responder);
                break;
            }
            case "resources/list": {
                this.resourceHandler.resourcesList(message, responder);
                break;
            }
            case "resources/read": {
                this.resourceHandler.resourcesRead(message, responder, connection, securitySupport);
                break;
            }
            case "resources/subscribe": {
                this.resourceHandler.resourcesSubscribe(message, responder, connection);
                break;
            }
            case "resources/unsubscribe": {
                this.resourceHandler.resourcesUnsubscribe(message, responder, connection);
                break;
            }
            case "resources/templates/list": {
                this.resourceTemplateHandler.resourceTemplatesList(message, responder);
                break;
            }
            case "completion/complete": {
                this.complete(message, responder, connection, securitySupport);
                break;
            }
            case "logging/setLevel": {
                this.setLogLevel(message, responder, connection);
                break;
            }
            case "q/close": {
                this.close(message, responder, connection);
                break;
            }
            default: {
                responder.send(Messages.newError(message.getValue("id"), -32601, "Unsupported method: " + method));
            }
        }
    }

    private void setLogLevel(JsonObject message, Responder responder, McpConnection connection) {
        Object id = message.getValue("id");
        JsonObject params = message.getJsonObject("params");
        String level = params.getString("level");
        if (level == null) {
            responder.sendError(id, -32600, "Log level not set");
        } else {
            McpLog.LogLevel logLevel = McpLog.LogLevel.from(level);
            if (logLevel == null) {
                responder.sendError(id, -32600, "Invalid log level set: " + level);
            } else if (connection instanceof McpConnectionBase) {
                McpConnectionBase connectionBase = (McpConnectionBase)connection;
                connectionBase.setLogLevel(logLevel);
                responder.sendResult(id, new JsonObject());
            } else {
                throw new IllegalStateException();
            }
        }
    }

    private void complete(JsonObject message, Responder responder, McpConnection connection, SecuritySupport securitySupport) {
        Object id = message.getValue("id");
        JsonObject params = message.getJsonObject("params");
        JsonObject ref = params.getJsonObject("ref");
        if (ref == null) {
            responder.sendError(id, -32600, "Reference not found");
        } else {
            String referenceType = ref.getString("type");
            if (referenceType == null) {
                responder.sendError(id, -32600, "Reference type not found");
            } else {
                JsonObject argument = params.getJsonObject("argument");
                if (argument == null) {
                    responder.sendError(id, -32600, "Argument not found");
                } else if ("ref/prompt".equals(referenceType)) {
                    this.promptCompleteHandler.complete(id, ref, argument, responder, connection, securitySupport);
                } else if ("ref/resource".equals(referenceType)) {
                    this.resourceTemplateCompleteHandler.complete(id, ref, argument, responder, connection, securitySupport);
                } else {
                    responder.sendError(id, -32600, "Unsupported reference found: " + ref.getString("type"));
                }
            }
        }
    }

    private void ping(JsonObject message, Responder responder) {
        Object id = message.getValue("id");
        LOG.debugf("Ping [id: %s]", id);
        responder.sendResult(id, new JsonObject());
    }

    private void close(JsonObject message, Responder responder, McpConnection connection) {
        if (this.connectionManager.remove(connection.id())) {
            LOG.debugf("Connection %s explicitly closed ", (Object)connection.id());
        } else {
            responder.sendError(message.getValue("id"), -32603, "Unable to obtain the connection to be closed:" + connection.id());
        }
    }

    private InitialRequest decodeInitializeRequest(JsonObject params) {
        JsonObject clientInfo = params.getJsonObject("clientInfo");
        Implementation implementation = new Implementation(clientInfo.getString("name"), clientInfo.getString("version"));
        String protocolVersion = params.getString("protocolVersion");
        ArrayList<ClientCapability> clientCapabilities = new ArrayList<ClientCapability>();
        JsonObject capabilities = params.getJsonObject("capabilities");
        if (capabilities != null) {
            for (String name : capabilities.fieldNames()) {
                clientCapabilities.add(new ClientCapability(name, Map.of()));
            }
        }
        return new InitialRequest(implementation, protocolVersion, List.copyOf(clientCapabilities));
    }

    private Map<String, Object> serverInfo(PromptManagerImpl promptManager, ToolManagerImpl toolManager, ResourceManagerImpl resourceManager, ResourceTemplateManagerImpl resourceTemplateManager, McpMetadata metadata) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("protocolVersion", DEFAULT_PROTOCOL_VERSION);
        String serverName = this.config.serverInfo().name().orElse(ConfigProvider.getConfig().getOptionalValue("quarkus.application.name", String.class).orElse("N/A"));
        String serverVersion = this.config.serverInfo().version().orElse(ConfigProvider.getConfig().getOptionalValue("quarkus.application.version", String.class).orElse("N/A"));
        info.put("serverInfo", Map.of("name", serverName, "version", serverVersion));
        HashMap capabilities = new HashMap();
        if (!promptManager.isEmpty() || metadata.isPromptManagerUsed()) {
            capabilities.put("prompts", metadata.isPromptManagerUsed() ? Map.of("listChanged", true) : Map.of());
        }
        if (!toolManager.isEmpty() || metadata.isToolManagerUsed()) {
            capabilities.put("tools", metadata.isToolManagerUsed() ? Map.of("listChanged", true) : Map.of());
        }
        if (!resourceManager.isEmpty() || !resourceTemplateManager.isEmpty() || metadata.isResourceManagerUsed()) {
            capabilities.put("resources", metadata.isResourceManagerUsed() ? Map.of("listChanged", true) : Map.of());
        }
        capabilities.put("logging", Map.of());
        info.put("capabilities", capabilities);
        return info;
    }
}

