/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.runtime.Cursor;
import io.quarkiverse.mcp.server.runtime.Responder;
import io.vertx.core.json.JsonObject;
import org.jboss.logging.Logger;

public class Messages {
    private static final Logger LOG = Logger.getLogger(Messages.class);

    public static JsonObject newResult(Object id, Object result) {
        JsonObject response = new JsonObject();
        response.put("jsonrpc", "2.0");
        response.put("id", id);
        response.put("result", result);
        return response;
    }

    public static JsonObject newError(Object id, int code, String message) {
        JsonObject response = new JsonObject();
        response.put("jsonrpc", "2.0");
        response.put("id", id);
        response.put("error", new JsonObject().put("code", code).put("message", message));
        return response;
    }

    public static JsonObject newNotification(String method, Object params) {
        JsonObject ret = new JsonObject().put("jsonrpc", "2.0").put("method", method);
        if (params != null) {
            ret.put("params", params);
        }
        return ret;
    }

    public static JsonObject newNotification(String method) {
        return Messages.newNotification(method, null);
    }

    public static JsonObject newPing(Object id) {
        return new JsonObject().put("jsonrpc", "2.0").put("id", id).put("method", "ping");
    }

    public static boolean isResponse(JsonObject message) {
        return message.containsKey("result") && message.containsKey("error");
    }

    static Cursor getCursor(JsonObject message, Responder responder) {
        String cursorVal;
        JsonObject params = message.getJsonObject("params");
        if (params != null && (cursorVal = params.getString("cursor")) != null) {
            try {
                return Cursor.decode(cursorVal);
            }
            catch (Exception e) {
                LOG.warnf("Invalid cursor detected %s: %s", (Object)cursorVal, (Object)e.toString());
                responder.sendError(message.getValue("id"), -32602, "Invalid cursor detected: " + cursorVal);
                return null;
            }
        }
        return Cursor.FIRST_PAGE;
    }
}

