/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.mcp.server.PromptManager;
import io.quarkiverse.mcp.server.PromptResponse;
import io.quarkiverse.mcp.server.RequestId;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.Feature;
import io.quarkiverse.mcp.server.runtime.FeatureManagerBase;
import io.quarkiverse.mcp.server.runtime.FeatureMetadata;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.McpMetadata;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Singleton
public class PromptManagerImpl
extends FeatureManagerBase<PromptResponse, PromptManager.PromptInfo>
implements PromptManager {
    final ConcurrentMap<String, PromptManager.PromptInfo> prompts = new ConcurrentHashMap<String, PromptManager.PromptInfo>();

    PromptManagerImpl(McpMetadata metadata, Vertx vertx, ObjectMapper mapper, ConnectionManager connectionManager, Instance<CurrentIdentityAssociation> currentIdentityAssociation) {
        super(vertx, mapper, connectionManager, currentIdentityAssociation);
        for (FeatureMetadata<PromptResponse> f : metadata.prompts()) {
            this.prompts.put(f.info().name(), new PromptMethod(f));
        }
    }

    @Override
    Stream<PromptManager.PromptInfo> infoStream() {
        return this.prompts.values().stream();
    }

    @Override
    public int size() {
        return this.prompts.size();
    }

    @Override
    public PromptManager.PromptInfo getPrompt(String name) {
        return (PromptManager.PromptInfo)this.prompts.get(Objects.requireNonNull(name));
    }

    @Override
    public PromptManager.PromptDefinition newPrompt(String name) {
        if (this.prompts.containsKey(name)) {
            throw this.promptWithNameAlreadyExists(name);
        }
        return new PromptDefinitionImpl(name);
    }

    @Override
    public PromptManager.PromptInfo removePrompt(String name) {
        return this.prompts.computeIfPresent(name, (key, value) -> {
            if (!value.isMethod()) {
                this.notifyConnections("notifications/prompts/list_changed");
                return null;
            }
            return value;
        });
    }

    @Override
    public boolean isEmpty() {
        return this.prompts.isEmpty();
    }

    IllegalArgumentException promptWithNameAlreadyExists(String name) {
        return new IllegalArgumentException("A prompt with name [" + name + "] already exits");
    }

    @Override
    protected McpException notFound(String id) {
        return new McpException("Invalid prompt name: " + id, -32602);
    }

    @Override
    protected FeatureManagerBase.FeatureInvoker<PromptResponse> getInvoker(String id) {
        PromptManager.PromptInfo prompt = (PromptManager.PromptInfo)this.prompts.get(id);
        if (prompt instanceof FeatureManagerBase.FeatureInvoker) {
            FeatureManagerBase.FeatureInvoker fi = (FeatureManagerBase.FeatureInvoker)((Object)prompt);
            return fi;
        }
        return null;
    }

    class PromptMethod
    extends FeatureManagerBase.FeatureMetadataInvoker<PromptResponse>
    implements PromptManager.PromptInfo {
        private PromptMethod(FeatureMetadata<PromptResponse> metadata) {
            super(metadata);
        }

        @Override
        public String name() {
            return this.metadata.info().name();
        }

        @Override
        public String description() {
            return this.metadata.info().description();
        }

        @Override
        public boolean isMethod() {
            return true;
        }

        @Override
        public List<PromptManager.PromptArgument> arguments() {
            return this.metadata.info().serializedArguments().stream().map(a -> new PromptManager.PromptArgument(a.name(), a.description(), a.required())).toList();
        }

        @Override
        public JsonObject asJson() {
            return this.metadata.asJson();
        }
    }

    class PromptDefinitionImpl
    extends FeatureManagerBase.FeatureDefinitionBase<PromptManager.PromptInfo, PromptManager.PromptArguments, PromptResponse, PromptDefinitionImpl>
    implements PromptManager.PromptDefinition {
        private final List<PromptManager.PromptArgument> arguments;

        PromptDefinitionImpl(String name) {
            super(name);
            this.arguments = new ArrayList<PromptManager.PromptArgument>();
        }

        @Override
        public PromptManager.PromptDefinition addArgument(String name, String description, boolean required) {
            this.arguments.add(new PromptManager.PromptArgument(name, description, required));
            return this;
        }

        @Override
        public PromptManager.PromptInfo register() {
            this.validate();
            PromptDefinitionInfo ret = new PromptDefinitionInfo(this.name, this.description, this.fun, this.asyncFun, this.runOnVirtualThread, this.arguments);
            PromptManager.PromptInfo existing = PromptManagerImpl.this.prompts.putIfAbsent(this.name, ret);
            if (existing != null) {
                throw PromptManagerImpl.this.promptWithNameAlreadyExists(this.name);
            }
            PromptManagerImpl.this.notifyConnections("notifications/prompts/list_changed");
            return ret;
        }
    }

    class PromptDefinitionInfo
    extends FeatureManagerBase.FeatureDefinitionInfoBase<PromptManager.PromptArguments, PromptResponse>
    implements PromptManager.PromptInfo {
        private final List<PromptManager.PromptArgument> arguments;

        private PromptDefinitionInfo(String name, String description, Function<PromptManager.PromptArguments, PromptResponse> fun, Function<PromptManager.PromptArguments, Uni<PromptResponse>> asyncFun, boolean runOnVirtualThread, List<PromptManager.PromptArgument> arguments) {
            super(name, description, fun, asyncFun, runOnVirtualThread);
            this.arguments = List.copyOf(arguments);
        }

        @Override
        public List<PromptManager.PromptArgument> arguments() {
            return this.arguments;
        }

        @Override
        protected PromptManager.PromptArguments createArguments(ArgumentProviders argumentProviders) {
            return new PromptManager.PromptArguments(argumentProviders.args().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue().toString())), argumentProviders.connection(), PromptManagerImpl.this.log(Feature.PROMPT.toString().toLowerCase() + ":" + this.name, this.name, argumentProviders), new RequestId(argumentProviders.requestId()));
        }

        @Override
        public JsonObject asJson() {
            JsonObject prompt = new JsonObject().put("name", this.name()).put("description", this.description());
            JsonArray arguments = new JsonArray();
            for (PromptManager.PromptArgument a : this.arguments) {
                arguments.add(new JsonObject().put("name", a.name()).put("description", a.description()).put("required", a.required()));
            }
            prompt.put("arguments", arguments);
            return prompt;
        }
    }
}

