/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.mcp.server.RequestId;
import io.quarkiverse.mcp.server.RequestUri;
import io.quarkiverse.mcp.server.ResourceContentsEncoder;
import io.quarkiverse.mcp.server.ResourceManager;
import io.quarkiverse.mcp.server.ResourceResponse;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.EncoderMapper;
import io.quarkiverse.mcp.server.runtime.Feature;
import io.quarkiverse.mcp.server.runtime.FeatureManagerBase;
import io.quarkiverse.mcp.server.runtime.FeatureMetadata;
import io.quarkiverse.mcp.server.runtime.McpConnectionBase;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.McpMetadata;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateManagerImpl;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Singleton
public class ResourceManagerImpl
extends FeatureManagerBase<ResourceResponse, ResourceManager.ResourceInfo>
implements ResourceManager {
    final ResourceTemplateManagerImpl resourceTemplateManager;
    final ConcurrentMap<String, ResourceManager.ResourceInfo> resources;
    final ConcurrentMap<String, List<String>> subscribers;

    ResourceManagerImpl(McpMetadata metadata, Vertx vertx, ObjectMapper mapper, ResourceTemplateManagerImpl resourceTemplateManager, ConnectionManager connectionManager, Instance<CurrentIdentityAssociation> currentIdentityAssociation) {
        super(vertx, mapper, connectionManager, currentIdentityAssociation);
        this.resourceTemplateManager = resourceTemplateManager;
        this.resources = new ConcurrentHashMap<String, ResourceManager.ResourceInfo>();
        this.subscribers = new ConcurrentHashMap<String, List<String>>();
        for (FeatureMetadata<ResourceResponse> f : metadata.resources()) {
            this.resources.put(f.info().uri(), new ResourceMethod(f));
        }
    }

    @Override
    Stream<ResourceManager.ResourceInfo> infoStream() {
        return this.resources.values().stream();
    }

    @Override
    public int size() {
        return this.resources.size();
    }

    @Override
    public ResourceManager.ResourceInfo getResource(String uri) {
        return (ResourceManager.ResourceInfo)this.resources.get(Objects.requireNonNull(uri));
    }

    void subscribe(String uri, String connectionId) {
        if (this.getResource(uri) == null) {
            throw this.notFound(uri);
        }
        CopyOnWriteArrayList<String> ids = new CopyOnWriteArrayList<String>();
        ids.add(connectionId);
        this.subscribers.merge(uri, ids, (old, val) -> Stream.concat(old.stream(), val.stream()).collect(Collectors.toCollection(CopyOnWriteArrayList::new)));
    }

    void unsubscribe(String uri, String connectionId) {
        List ids = (List)this.subscribers.get(uri);
        if (ids != null) {
            ids.remove(connectionId);
        }
    }

    @Override
    public ResourceManager.ResourceDefinition newResource(String name) {
        for (ResourceManager.ResourceInfo resource : this.resources.values()) {
            if (!resource.name().equals(name)) continue;
            this.resourceWithNameAlreadyExists(name);
        }
        return new ResourceDefinitionImpl(name);
    }

    private void sendUpdateNotifications(String uri) {
        JsonObject updated = Messages.newNotification("notifications/resources/updated", new JsonObject().put("uri", uri));
        List ids = (List)this.subscribers.get(uri);
        for (String connectionId : ids) {
            McpConnectionBase connection = this.connectionManager.get(connectionId);
            if (connection != null) {
                connection.send(updated);
                continue;
            }
            this.unsubscribe(uri, connectionId);
        }
    }

    IllegalArgumentException resourceWithNameAlreadyExists(String name) {
        return new IllegalArgumentException("A resource with name [" + name + "] already exits");
    }

    IllegalArgumentException resourceWithUriAlreadyExists(String uri) {
        return new IllegalArgumentException("A resource with uri [" + uri + "] already exits");
    }

    @Override
    public ResourceManager.ResourceInfo removeResource(String uri) {
        return this.resources.computeIfPresent(uri, (key, value) -> {
            if (!value.isMethod()) {
                this.notifyConnections("notifications/resources/list_changed");
                return null;
            }
            return value;
        });
    }

    @Override
    protected FeatureManagerBase.FeatureInvoker<ResourceResponse> getInvoker(String id) {
        ResourceManager.ResourceInfo resource = (ResourceManager.ResourceInfo)this.resources.get(id);
        if (resource instanceof FeatureManagerBase.FeatureInvoker) {
            FeatureManagerBase.FeatureInvoker fi = (FeatureManagerBase.FeatureInvoker)((Object)resource);
            return fi;
        }
        return this.resourceTemplateManager.getInvoker(id);
    }

    @Override
    protected Object wrapResult(Object ret, FeatureMetadata<?> metadata, ArgumentProviders argProviders) {
        if (metadata.resultMapper() instanceof EncoderMapper) {
            if (ret instanceof Uni) {
                Uni uni = (Uni)ret;
                return uni.map(i -> {
                    if (i instanceof List) {
                        List list = (List)i;
                        return list.stream().map(e -> new ResourceContentsEncoder.ResourceContentsData<Object>(new RequestUri(argProviders.uri()), e)).toList();
                    }
                    return new ResourceContentsEncoder.ResourceContentsData<Object>(new RequestUri(argProviders.uri()), i);
                });
            }
            if (ret instanceof List) {
                List list = (List)ret;
                return list.stream().map(e -> new ResourceContentsEncoder.ResourceContentsData<Object>(new RequestUri(argProviders.uri()), e)).toList();
            }
            return new ResourceContentsEncoder.ResourceContentsData<Object>(new RequestUri(argProviders.uri()), ret);
        }
        return super.wrapResult(ret, metadata, argProviders);
    }

    @Override
    protected McpException notFound(String id) {
        return new McpException("Invalid resource uri: " + id, -32002);
    }

    class ResourceMethod
    extends FeatureManagerBase.FeatureMetadataInvoker<ResourceResponse>
    implements ResourceManager.ResourceInfo {
        private ResourceMethod(FeatureMetadata<ResourceResponse> metadata) {
            super(metadata);
        }

        @Override
        public String name() {
            return this.metadata.info().name();
        }

        @Override
        public String description() {
            return this.metadata.info().description();
        }

        @Override
        public String uri() {
            return this.metadata.info().uri();
        }

        @Override
        public String mimeType() {
            return this.metadata.info().mimeType();
        }

        @Override
        public boolean isMethod() {
            return true;
        }

        @Override
        public JsonObject asJson() {
            return this.metadata.asJson();
        }

        @Override
        public void sendUpdate() {
            ResourceManagerImpl.this.sendUpdateNotifications(this.uri());
        }
    }

    class ResourceDefinitionImpl
    extends FeatureManagerBase.FeatureDefinitionBase<ResourceManager.ResourceInfo, ResourceManager.ResourceArguments, ResourceResponse, ResourceDefinitionImpl>
    implements ResourceManager.ResourceDefinition {
        private String uri;
        private String mimeType;

        ResourceDefinitionImpl(String name) {
            super(name);
        }

        @Override
        public ResourceManager.ResourceDefinition setUri(String uri) {
            if (ResourceManagerImpl.this.resources.containsKey(uri)) {
                throw ResourceManagerImpl.this.resourceWithUriAlreadyExists(uri);
            }
            this.uri = Objects.requireNonNull(uri);
            return this;
        }

        @Override
        public ResourceManager.ResourceDefinition setMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        @Override
        public ResourceManager.ResourceInfo register() {
            this.validate();
            ResourceDefinitionInfo ret = new ResourceDefinitionInfo(this.name, this.description, this.fun, this.asyncFun, this.runOnVirtualThread, this.uri, this.mimeType);
            ResourceManager.ResourceInfo existing = ResourceManagerImpl.this.resources.putIfAbsent(this.uri, ret);
            if (existing != null) {
                throw ResourceManagerImpl.this.resourceWithUriAlreadyExists(this.uri);
            }
            ResourceManagerImpl.this.notifyConnections("notifications/resources/list_changed");
            return ret;
        }
    }

    class ResourceDefinitionInfo
    extends FeatureManagerBase.FeatureDefinitionInfoBase<ResourceManager.ResourceArguments, ResourceResponse>
    implements ResourceManager.ResourceInfo {
        private final String uri;
        private final String mimeType;

        private ResourceDefinitionInfo(String name, String description, Function<ResourceManager.ResourceArguments, ResourceResponse> fun, Function<ResourceManager.ResourceArguments, Uni<ResourceResponse>> asyncFun, boolean runOnVirtualThread, String uri, String mimeType) {
            super(name, description, fun, asyncFun, runOnVirtualThread);
            this.uri = uri;
            this.mimeType = mimeType;
        }

        @Override
        public String uri() {
            return this.uri;
        }

        @Override
        public String mimeType() {
            return this.mimeType;
        }

        @Override
        public JsonObject asJson() {
            JsonObject ret = new JsonObject().put("name", this.name()).put("description", this.description()).put("uri", this.uri);
            if (this.mimeType != null) {
                ret.put("mimeType", this.mimeType);
            }
            return ret;
        }

        @Override
        protected ResourceManager.ResourceArguments createArguments(ArgumentProviders argumentProviders) {
            return new ResourceManager.ResourceArguments(argumentProviders.connection(), ResourceManagerImpl.this.log(Feature.RESOURCE.toString().toLowerCase() + ":" + this.name, this.name, argumentProviders), new RequestId(argumentProviders.requestId()), new RequestUri(argumentProviders.uri()));
        }

        @Override
        public void sendUpdate() {
            ResourceManagerImpl.this.sendUpdateNotifications(this.uri());
        }
    }
}

