/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.McpConnection;
import io.quarkiverse.mcp.server.ResourceManager;
import io.quarkiverse.mcp.server.ResourceResponse;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.Cursor;
import io.quarkiverse.mcp.server.runtime.FeatureManagerBase;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.MessageHandler;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.Page;
import io.quarkiverse.mcp.server.runtime.ResourceManagerImpl;
import io.quarkiverse.mcp.server.runtime.Responder;
import io.quarkiverse.mcp.server.runtime.SecuritySupport;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import java.util.Objects;
import org.jboss.logging.Logger;

class ResourceMessageHandler
extends MessageHandler {
    private static final Logger LOG = Logger.getLogger(ResourceMessageHandler.class);
    private final ResourceManagerImpl manager;
    private final int pageSize;

    ResourceMessageHandler(ResourceManagerImpl manager, int pageSize) {
        this.manager = Objects.requireNonNull(manager);
        this.pageSize = pageSize;
    }

    void resourcesSubscribe(JsonObject message, Responder responder, McpConnection connection) {
        Object id = message.getValue("id");
        JsonObject params = message.getJsonObject("params");
        String resourceUri = params.getString("uri");
        if (resourceUri == null) {
            responder.sendError(id, -32602, "Resource URI not defined");
            return;
        }
        LOG.debugf("Subscribe to resource %s [id: %s]", (Object)resourceUri, id);
        this.manager.subscribe(resourceUri, connection.id());
    }

    void resourcesUnsubscribe(JsonObject message, Responder responder, McpConnection connection) {
        Object id = message.getValue("id");
        JsonObject params = message.getJsonObject("params");
        String resourceUri = params.getString("uri");
        if (resourceUri == null) {
            responder.sendError(id, -32602, "Resource URI not defined");
            return;
        }
        LOG.debugf("Unsubscribe to resource %s [id: %s]", (Object)resourceUri, id);
        this.manager.unsubscribe(resourceUri, connection.id());
    }

    void resourcesList(JsonObject message, Responder responder) {
        Object id = message.getValue("id");
        Cursor cursor = Messages.getCursor(message, responder);
        LOG.debugf("List resources [id: %s, cursor: %s]", id, (Object)cursor);
        JsonArray resources = new JsonArray();
        JsonObject result = new JsonObject().put("resources", resources);
        Page page = this.manager.fetchPage(cursor, this.pageSize);
        for (ResourceManager.ResourceInfo info : page) {
            resources.add(info.asJson());
        }
        if (page.hasNextCursor()) {
            ResourceManager.ResourceInfo last = (ResourceManager.ResourceInfo)page.lastInfo();
            result.put("nextCursor", Cursor.encode(last.createdAt(), last.name()));
        }
        responder.sendResult(id, result);
    }

    void resourcesRead(JsonObject message, final Responder responder, final McpConnection connection, SecuritySupport securitySupport) {
        final Object id = message.getValue("id");
        JsonObject params = message.getJsonObject("params");
        final String resourceUri = params.getString("uri");
        if (resourceUri == null) {
            responder.sendError(id, -32602, "Resource URI not defined");
            return;
        }
        LOG.debugf("Read resource %s [id: %s]", (Object)resourceUri, id);
        ArgumentProviders argProviders = new ArgumentProviders(Map.of(), connection, id, resourceUri, responder);
        try {
            Future fu = this.manager.execute(resourceUri, new FeatureManagerBase.FeatureExecutionContext(argProviders, securitySupport));
            fu.onComplete(new Handler<AsyncResult<ResourceResponse>>(){

                @Override
                public void handle(AsyncResult<ResourceResponse> ar) {
                    if (ar.succeeded()) {
                        ResourceResponse resourceResponse = ar.result();
                        responder.sendResult(id, resourceResponse);
                    } else {
                        ResourceMessageHandler.this.handleFailure(id, responder, connection, ar.cause(), LOG, "Unable to read resource %s", resourceUri);
                    }
                }
            });
        }
        catch (McpException e) {
            responder.sendError(id, e.getJsonRpcError(), e.getMessage());
        }
    }
}

