/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.ResourceTemplateManager;
import io.quarkiverse.mcp.server.runtime.Cursor;
import io.quarkiverse.mcp.server.runtime.MessageHandler;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.Page;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateManagerImpl;
import io.quarkiverse.mcp.server.runtime.Responder;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import org.jboss.logging.Logger;

class ResourceTemplateMessageHandler
extends MessageHandler {
    private static final Logger LOG = Logger.getLogger(ResourceTemplateMessageHandler.class);
    private final ResourceTemplateManagerImpl manager;
    private final int pageSize;

    ResourceTemplateMessageHandler(ResourceTemplateManagerImpl manager, int pageSize) {
        this.manager = manager;
        this.pageSize = pageSize;
    }

    void resourceTemplatesList(JsonObject message, Responder responder) {
        Object id = message.getValue("id");
        Cursor cursor = Messages.getCursor(message, responder);
        LOG.debugf("List resource templates [id: %s, cursor: %s]", id, (Object)cursor);
        JsonArray templates = new JsonArray();
        JsonObject result = new JsonObject().put("resourceTemplates", templates);
        Page page = this.manager.fetchPage(cursor, this.pageSize);
        for (ResourceTemplateManager.ResourceTemplateInfo info : page) {
            templates.add(info.asJson());
        }
        if (page.hasNextCursor()) {
            ResourceTemplateManager.ResourceTemplateInfo last = (ResourceTemplateManager.ResourceTemplateInfo)page.lastInfo();
            result.put("nextCursor", Cursor.encode(last.createdAt(), last.name()));
        }
        responder.sendResult(id, result);
    }
}

