/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.Content;
import io.quarkiverse.mcp.server.ContentEncoder;
import io.quarkiverse.mcp.server.ToolResponse;
import io.quarkiverse.mcp.server.ToolResponseEncoder;
import io.quarkiverse.mcp.server.runtime.EncoderMapper;
import io.quarkiverse.mcp.server.runtime.ListEncoderResultMapper;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkus.arc.All;
import io.smallrye.mutiny.Uni;
import jakarta.inject.Singleton;
import java.util.List;

@Singleton
public class ToolEncoderResultMapper
extends ListEncoderResultMapper<Content, ContentEncoder<?>, ToolResponse> {
    @All
    List<ToolResponseEncoder<?>> toolResponseEncoders;
    final EncoderMapper<Uni<Object>, ToolResponse> uni = new EncoderMapper<Uni<Object>, ToolResponse>(){

        @Override
        public Uni<ToolResponse> apply(Uni<Object> uni) {
            return uni.chain(o -> ToolEncoderResultMapper.this.apply(o));
        }
    };

    private ToolEncoderResultMapper() {
    }

    @Override
    public Uni<ToolResponse> apply(Object obj) {
        Object ret = null;
        ToolResponse toolResponse = this.convertContainer(obj);
        ret = toolResponse != null ? Uni.createFrom().item(toolResponse) : super.apply(obj);
        return ret;
    }

    @Override
    public EncoderMapper<Uni<Object>, ToolResponse> uni() {
        return this.uni;
    }

    @Override
    protected ToolResponse toResponse(List<Content> content) {
        return ToolResponse.success(content);
    }

    @Override
    protected ToolResponse convertContainer(Object obj) {
        Class<?> type = obj.getClass();
        for (ToolResponseEncoder<?> encoder : this.toolResponseEncoders) {
            ToolResponse encoded;
            if (!encoder.supports(type)) continue;
            try {
                encoded = (ToolResponse)encoder.encode(ToolEncoderResultMapper.cast(obj));
            }
            catch (Exception e) {
                throw new McpException("Unable to encode object of type " + String.valueOf(type) + " with " + encoder.getClass().getName(), -32603);
            }
            return encoded;
        }
        return null;
    }
}

