/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import io.quarkiverse.mcp.server.RequestId;
import io.quarkiverse.mcp.server.ToolManager;
import io.quarkiverse.mcp.server.ToolResponse;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.Feature;
import io.quarkiverse.mcp.server.runtime.FeatureArgument;
import io.quarkiverse.mcp.server.runtime.FeatureManagerBase;
import io.quarkiverse.mcp.server.runtime.FeatureMetadata;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.McpMetadata;
import io.quarkiverse.mcp.server.runtime.Types;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Stream;

@Singleton
public class ToolManagerImpl
extends FeatureManagerBase<ToolResponse, ToolManager.ToolInfo>
implements ToolManager {
    private final SchemaGenerator schemaGenerator;
    final ConcurrentMap<String, ToolManager.ToolInfo> tools = new ConcurrentHashMap<String, ToolManager.ToolInfo>();

    ToolManagerImpl(McpMetadata metadata, Vertx vertx, ObjectMapper mapper, ConnectionManager connectionManager, Instance<CurrentIdentityAssociation> currentIdentityAssociation) {
        super(vertx, mapper, connectionManager, currentIdentityAssociation);
        for (FeatureMetadata<ToolResponse> f : metadata.tools()) {
            this.tools.put(f.info().name(), new ToolMethod(f));
        }
        this.schemaGenerator = new SchemaGenerator(new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON).without(Option.SCHEMA_VERSION_INDICATOR, new Option[0]).build());
    }

    @Override
    Stream<ToolManager.ToolInfo> infoStream() {
        return this.tools.values().stream();
    }

    @Override
    public int size() {
        return this.tools.size();
    }

    @Override
    public ToolManager.ToolInfo getTool(String name) {
        return (ToolManager.ToolInfo)this.tools.get(Objects.requireNonNull(name));
    }

    @Override
    public ToolManager.ToolDefinition newTool(String name) {
        if (this.tools.containsKey(name)) {
            throw this.toolAlreadyExists(name);
        }
        return new ToolDefinitionImpl(name);
    }

    IllegalArgumentException toolAlreadyExists(String name) {
        return new IllegalArgumentException("A tool with name [" + name + "] already exits");
    }

    @Override
    public ToolManager.ToolInfo removeTool(String name) {
        return this.tools.computeIfPresent(name, (key, value) -> {
            if (!value.isMethod()) {
                this.notifyConnections("notifications/tools/list_changed");
                return null;
            }
            return value;
        });
    }

    @Override
    protected FeatureManagerBase.FeatureInvoker<ToolResponse> getInvoker(String id) {
        ToolManager.ToolInfo tool = (ToolManager.ToolInfo)this.tools.get(id);
        if (tool instanceof FeatureManagerBase.FeatureInvoker) {
            FeatureManagerBase.FeatureInvoker fi = (FeatureManagerBase.FeatureInvoker)((Object)tool);
            return fi;
        }
        return null;
    }

    @Override
    protected McpException notFound(String id) {
        return new McpException("Invalid tool name: " + id, -32602);
    }

    Object generateSchema(Type type, String description) {
        ObjectNode jsonNode = this.schemaGenerator.generateSchema(type, new Type[0]);
        if (((JsonNode)jsonNode).isObject()) {
            ObjectNode objectNode = jsonNode;
            if (description != null && !description.isBlank()) {
                objectNode.put("description", description);
            }
            if (Types.isOptional(type)) {
                ObjectNode valueType = objectNode.withObjectProperty("properties").withObjectProperty("value");
                objectNode.set("type", valueType.get("type"));
                if (valueType.has("properties")) {
                    objectNode.set("properties", valueType.get("properties"));
                } else {
                    objectNode.remove("properties");
                }
            }
        }
        return jsonNode;
    }

    class ToolMethod
    extends FeatureManagerBase.FeatureMetadataInvoker<ToolResponse>
    implements ToolManager.ToolInfo {
        private ToolMethod(FeatureMetadata<ToolResponse> metadata) {
            super(metadata);
        }

        @Override
        public String name() {
            return this.metadata.info().name();
        }

        @Override
        public String description() {
            return this.metadata.info().description();
        }

        @Override
        public boolean isMethod() {
            return true;
        }

        @Override
        public List<ToolManager.ToolArgument> arguments() {
            return this.metadata.info().serializedArguments().stream().map(fa -> new ToolManager.ToolArgument(fa.name(), fa.description(), fa.required(), fa.type())).toList();
        }

        @Override
        public JsonObject asJson() {
            JsonObject tool = this.metadata.asJson();
            JsonObject properties = new JsonObject();
            JsonArray required = new JsonArray();
            for (FeatureArgument a : this.metadata.info().serializedArguments()) {
                properties.put(a.name(), ToolManagerImpl.this.generateSchema(a.type(), a.description()));
                if (!a.required()) continue;
                required.add(a.name());
            }
            tool.put("inputSchema", new JsonObject().put("type", "object").put("properties", properties).put("required", required));
            return tool;
        }
    }

    class ToolDefinitionImpl
    extends FeatureManagerBase.FeatureDefinitionBase<ToolManager.ToolInfo, ToolManager.ToolArguments, ToolResponse, ToolDefinitionImpl>
    implements ToolManager.ToolDefinition {
        private final List<ToolManager.ToolArgument> arguments;

        private ToolDefinitionImpl(String name) {
            super(name);
            this.arguments = new ArrayList<ToolManager.ToolArgument>();
        }

        @Override
        public ToolManager.ToolDefinition addArgument(String name, String description, boolean required, Type type) {
            this.arguments.add(new ToolManager.ToolArgument(name, description, required, type));
            return this;
        }

        @Override
        public ToolManager.ToolInfo register() {
            this.validate();
            ToolDefinitionInfo ret = new ToolDefinitionInfo(this.name, this.description, this.fun, this.asyncFun, this.runOnVirtualThread, this.arguments);
            ToolManager.ToolInfo existing = ToolManagerImpl.this.tools.putIfAbsent(this.name, ret);
            if (existing != null) {
                throw ToolManagerImpl.this.toolAlreadyExists(this.name);
            }
            ToolManagerImpl.this.notifyConnections("notifications/tools/list_changed");
            return ret;
        }
    }

    class ToolDefinitionInfo
    extends FeatureManagerBase.FeatureDefinitionInfoBase<ToolManager.ToolArguments, ToolResponse>
    implements ToolManager.ToolInfo {
        private final List<ToolManager.ToolArgument> arguments;

        private ToolDefinitionInfo(String name, String description, Function<ToolManager.ToolArguments, ToolResponse> fun, Function<ToolManager.ToolArguments, Uni<ToolResponse>> asyncFun, boolean runOnVirtualThread, List<ToolManager.ToolArgument> arguments) {
            super(name, description, fun, asyncFun, runOnVirtualThread);
            this.arguments = List.copyOf(arguments);
        }

        @Override
        public List<ToolManager.ToolArgument> arguments() {
            return this.arguments;
        }

        @Override
        public JsonObject asJson() {
            JsonObject tool = new JsonObject().put("name", this.name()).put("description", this.description());
            JsonObject properties = new JsonObject();
            JsonArray required = new JsonArray();
            for (ToolManager.ToolArgument a : this.arguments) {
                properties.put(a.name(), ToolManagerImpl.this.generateSchema(a.type(), a.description()));
                if (!a.required()) continue;
                required.add(a.name());
            }
            tool.put("inputSchema", new JsonObject().put("type", "object").put("properties", properties).put("required", required));
            return tool;
        }

        @Override
        protected ToolManager.ToolArguments createArguments(ArgumentProviders argumentProviders) {
            return new ToolManager.ToolArguments(argumentProviders.args(), argumentProviders.connection(), ToolManagerImpl.this.log(Feature.TOOL.toString().toLowerCase() + ":" + this.name, this.name, argumentProviders), new RequestId(argumentProviders.requestId()));
        }
    }
}

