/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.McpConnection;
import io.quarkiverse.mcp.server.ToolCallException;
import io.quarkiverse.mcp.server.ToolManager;
import io.quarkiverse.mcp.server.ToolResponse;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.Cursor;
import io.quarkiverse.mcp.server.runtime.FeatureManagerBase;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.MessageHandler;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.Page;
import io.quarkiverse.mcp.server.runtime.Responder;
import io.quarkiverse.mcp.server.runtime.SecuritySupport;
import io.quarkiverse.mcp.server.runtime.ToolManagerImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import java.util.Objects;
import org.jboss.logging.Logger;

class ToolMessageHandler
extends MessageHandler {
    private static final Logger LOG = Logger.getLogger(ToolMessageHandler.class);
    private final ToolManagerImpl manager;
    private final int pageSize;

    ToolMessageHandler(ToolManagerImpl manager, int pageSize) {
        this.manager = Objects.requireNonNull(manager);
        this.pageSize = pageSize;
    }

    void toolsList(JsonObject message, Responder responder) {
        Object id = message.getValue("id");
        Cursor cursor = Messages.getCursor(message, responder);
        LOG.debugf("List tools [id: %s, cursor: %s]", id, (Object)cursor);
        JsonArray tools = new JsonArray();
        JsonObject result = new JsonObject().put("tools", tools);
        Page page = this.manager.fetchPage(cursor, this.pageSize);
        for (ToolManager.ToolInfo info : page) {
            tools.add(info.asJson());
        }
        if (page.hasNextCursor()) {
            ToolManager.ToolInfo last = (ToolManager.ToolInfo)page.lastInfo();
            result.put("nextCursor", Cursor.encode(last.createdAt(), last.name()));
        }
        responder.sendResult(id, result);
    }

    void toolsCall(JsonObject message, final Responder responder, final McpConnection connection, SecuritySupport securitySupport) {
        final Object id = message.getValue("id");
        JsonObject params = message.getJsonObject("params");
        final String toolName = params.getString("name");
        LOG.debugf("Call tool %s [id: %s]", (Object)toolName, id);
        Map<String, Object> args = params.containsKey("arguments") ? params.getJsonObject("arguments").getMap() : Map.of();
        ArgumentProviders argProviders = new ArgumentProviders(args, connection, id, null, responder);
        try {
            Future fu = this.manager.execute(toolName, new FeatureManagerBase.FeatureExecutionContext(argProviders, securitySupport));
            fu.onComplete(new Handler<AsyncResult<ToolResponse>>(){

                @Override
                public void handle(AsyncResult<ToolResponse> ar) {
                    if (ar.succeeded()) {
                        ToolResponse toolResponse = ar.result();
                        responder.sendResult(id, toolResponse);
                    } else {
                        Throwable cause = ar.cause();
                        if (cause instanceof ToolCallException) {
                            ToolCallException tce = (ToolCallException)cause;
                            responder.sendResult(id, ToolResponse.error(tce.getMessage()));
                        } else {
                            ToolMessageHandler.this.handleFailure(id, responder, connection, cause, LOG, "Unable to call tool %s", toolName);
                        }
                    }
                }
            });
        }
        catch (McpException e) {
            responder.sendError(id, e.getJsonRpcError(), e.getMessage());
        }
    }
}

