/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime.config;

import io.quarkiverse.mcp.server.McpLog;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.time.Duration;
import java.util.Optional;

@ConfigMapping(prefix="quarkus.mcp.server")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface McpRuntimeConfig {
    public ServerInfo serverInfo();

    public TrafficLogging trafficLogging();

    public ClientLogging clientLogging();

    public Optional<Duration> autoPingInterval();

    public DevMode devMode();

    public Resources resources();

    public ResourceTemplates resourceTemplates();

    public Tools tools();

    public Prompts prompts();

    public static interface Tools {
        @WithDefault(value="50")
        public int pageSize();
    }

    public static interface Prompts {
        @WithDefault(value="50")
        public int pageSize();
    }

    public static interface ResourceTemplates {
        @WithDefault(value="50")
        public int pageSize();
    }

    public static interface Resources {
        @WithDefault(value="50")
        public int pageSize();
    }

    public static interface DevMode {
        @WithDefault(value="true")
        public boolean dummyInit();
    }

    public static interface ClientLogging {
        @WithDefault(value="INFO")
        public McpLog.LogLevel defaultLevel();
    }

    public static interface ServerInfo {
        public Optional<String> name();

        public Optional<String> version();
    }

    public static interface TrafficLogging {
        @WithDefault(value="false")
        public boolean enabled();

        @WithDefault(value="200")
        public int textLimit();
    }
}

