/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.sse.runtime.devui;

import io.quarkiverse.mcp.server.PromptManager;
import io.quarkiverse.mcp.server.ResourceManager;
import io.quarkiverse.mcp.server.ResourceTemplateManager;
import io.quarkiverse.mcp.server.ToolManager;
import io.quarkiverse.mcp.server.sse.client.SseClient;
import io.quarkiverse.mcp.server.sse.runtime.config.McpSseBuildTimeConfig;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

@ApplicationScoped
public class SseMcpJsonRPCService {
    private final ToolManager toolManager;
    private final PromptManager promptManager;
    private final ResourceManager resourceManager;
    private final ResourceTemplateManager resourceTemplateManager;
    private final DevUISseClient sseClient;
    private final AtomicReference<URI> messageEndpoint;
    private final HttpClient httpClient;
    private final AtomicBoolean initialized;
    private final AtomicInteger idGenerator;

    public SseMcpJsonRPCService(ToolManager toolManager, PromptManager promptManager, ResourceManager resourceManager, ResourceTemplateManager resourceTemplateManager, VertxHttpConfig httpConfig, VertxHttpBuildTimeConfig httpBuildConfig, McpSseBuildTimeConfig mcpSseBuildConfig) {
        this.toolManager = toolManager;
        this.promptManager = promptManager;
        this.resourceManager = resourceManager;
        this.resourceTemplateManager = resourceTemplateManager;
        this.sseClient = new DevUISseClient(URI.create("http://" + httpConfig.host() + ":" + httpConfig.port() + httpBuildConfig.rootPath() + this.pathToAppend(httpBuildConfig.rootPath(), mcpSseBuildConfig.rootPath()) + this.pathToAppend(mcpSseBuildConfig.rootPath(), "sse")));
        this.messageEndpoint = new AtomicReference();
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
        this.initialized = new AtomicBoolean();
        this.idGenerator = new AtomicInteger();
    }

    public JsonArray getToolsData() {
        JsonArray ret = new JsonArray();
        for (ToolManager.ToolInfo tool : this.toolManager) {
            JsonObject toolJson = tool.asJson();
            if (!tool.arguments().isEmpty()) {
                JsonArray args = new JsonArray();
                for (ToolManager.ToolArgument arg : tool.arguments()) {
                    JsonObject argJson = new JsonObject();
                    argJson.put("name", arg.name());
                    argJson.put("description", arg.description());
                    argJson.put("required", arg.required());
                    argJson.put("type", arg.type().getTypeName());
                    args.add(argJson);
                }
                toolJson.put("args", args);
            }
            toolJson.put("inputPrototype", this.createInputPrototype(tool));
            ret.add(toolJson);
        }
        return ret;
    }

    public JsonArray getPromptsData() {
        JsonArray ret = new JsonArray();
        for (PromptManager.PromptInfo prompt : this.promptManager) {
            JsonObject promptJson = prompt.asJson();
            JsonObject inputPrototype = new JsonObject();
            for (PromptManager.PromptArgument arg : prompt.arguments()) {
                inputPrototype.put(arg.name(), arg.description());
            }
            promptJson.put("inputPrototype", inputPrototype);
            ret.add(promptJson);
        }
        return ret;
    }

    public JsonArray getResourcesData() {
        JsonArray ret = new JsonArray();
        for (ResourceManager.ResourceInfo resource : this.resourceManager) {
            ret.add(resource.asJson());
        }
        return ret;
    }

    public JsonArray getResourceTemplatesData() {
        JsonArray ret = new JsonArray();
        for (ResourceTemplateManager.ResourceTemplateInfo resourceTemplate : this.resourceTemplateManager) {
            ret.add(resourceTemplate.asJson());
        }
        return ret;
    }

    private JsonObject createInputPrototype(ToolManager.ToolInfo tool) {
        JsonObject inputPrototype = new JsonObject();
        if (!tool.arguments().isEmpty()) {
            for (ToolManager.ToolArgument arg : tool.arguments()) {
                Type type = arg.type();
                if (type instanceof Class) {
                    Class clazz = (Class)type;
                    if (clazz.isPrimitive()) {
                        if (Integer.TYPE.equals(clazz) || Double.TYPE.equals(clazz) || Float.TYPE.equals(clazz) || Byte.TYPE.equals(clazz)) {
                            inputPrototype.put(arg.name(), 42);
                            continue;
                        }
                        if (Boolean.TYPE.equals(clazz)) {
                            inputPrototype.put(arg.name(), true);
                            continue;
                        }
                        this.unsupportedType(inputPrototype, arg);
                        continue;
                    }
                    if (String.class.equals((Object)arg.type())) {
                        inputPrototype.put(arg.name(), arg.description());
                        continue;
                    }
                    if (clazz.isAssignableFrom(Number.class)) {
                        inputPrototype.put(arg.name(), 42);
                        continue;
                    }
                    if (Boolean.class.equals((Object)clazz)) {
                        inputPrototype.put(arg.name(), true);
                        continue;
                    }
                    this.unsupportedType(inputPrototype, arg);
                    continue;
                }
                type = arg.type();
                if (type instanceof ParameterizedType) {
                    Class clazz;
                    ParameterizedType pt = (ParameterizedType)type;
                    Type type2 = pt.getRawType();
                    if (type2 instanceof Class && Collection.class.isAssignableFrom(clazz = (Class)type2)) {
                        inputPrototype.put(arg.name(), List.of());
                        continue;
                    }
                    this.unsupportedType(inputPrototype, arg);
                    continue;
                }
                if (arg.type() instanceof GenericArrayType) {
                    inputPrototype.put(arg.name(), List.of());
                    continue;
                }
                this.unsupportedType(inputPrototype, arg);
            }
        }
        return inputPrototype;
    }

    private void unsupportedType(JsonObject inputPrototype, ToolManager.ToolArgument arg) {
        inputPrototype.put(arg.name(), arg.type().getTypeName() + ": " + arg.description());
    }

    public JsonObject callTool(String name, JsonObject args) throws IOException, InterruptedException {
        if (this.toolManager.getTool(name) == null) {
            return new JsonObject().put("error", "Tool not found: " + name);
        }
        JsonObject initRet = this.ensureInitialized();
        if (initRet != null) {
            return initRet;
        }
        Integer requestId = this.idGenerator.incrementAndGet();
        JsonObject message = new JsonObject().put("jsonrpc", "2.0").put("id", requestId).put("method", "tools/call").put("params", new JsonObject().put("name", name).put("arguments", args));
        HttpRequest request = HttpRequest.newBuilder().uri(this.messageEndpoint.get()).version(HttpClient.Version.HTTP_1_1).POST(HttpRequest.BodyPublishers.ofString(message.encode())).build();
        HttpResponse<Void> response = this.httpClient.send(request, HttpResponse.BodyHandlers.discarding());
        if (response.statusCode() != 200) {
            return new JsonObject().put("error", "Invalid HTTP status: " + response.statusCode());
        }
        return new JsonObject().put("response", this.sseClient.awaitResponse(requestId));
    }

    public JsonObject getPrompt(String name, JsonObject args) throws IOException, InterruptedException {
        if (this.promptManager.getPrompt(name) == null) {
            return new JsonObject().put("error", "Prompt not found: " + name);
        }
        JsonObject initRet = this.ensureInitialized();
        if (initRet != null) {
            return initRet;
        }
        Integer requestId = this.idGenerator.incrementAndGet();
        JsonObject message = new JsonObject().put("jsonrpc", "2.0").put("id", requestId).put("method", "prompts/get").put("params", new JsonObject().put("name", name).put("arguments", args));
        HttpRequest request = HttpRequest.newBuilder().uri(this.messageEndpoint.get()).version(HttpClient.Version.HTTP_1_1).POST(HttpRequest.BodyPublishers.ofString(message.encode())).build();
        HttpResponse<Void> response = this.httpClient.send(request, HttpResponse.BodyHandlers.discarding());
        if (response.statusCode() != 200) {
            return new JsonObject().put("error", "Invalid HTTP status: " + response.statusCode());
        }
        return new JsonObject().put("response", this.sseClient.awaitResponse(requestId));
    }

    public JsonObject readResource(String uri) throws IOException, InterruptedException {
        if (uri == null || uri.isBlank()) {
            return new JsonObject().put("error", "Resource uri must be set");
        }
        JsonObject initRet = this.ensureInitialized();
        if (initRet != null) {
            return initRet;
        }
        Integer requestId = this.idGenerator.incrementAndGet();
        JsonObject message = new JsonObject().put("jsonrpc", "2.0").put("id", requestId).put("method", "resources/read").put("params", new JsonObject().put("uri", uri));
        HttpRequest request = HttpRequest.newBuilder().uri(this.messageEndpoint.get()).version(HttpClient.Version.HTTP_1_1).POST(HttpRequest.BodyPublishers.ofString(message.encode())).build();
        HttpResponse<Void> response = this.httpClient.send(request, HttpResponse.BodyHandlers.discarding());
        if (response.statusCode() != 200) {
            return new JsonObject().put("error", "Invalid HTTP status: " + response.statusCode());
        }
        return new JsonObject().put("response", this.sseClient.awaitResponse(requestId));
    }

    private JsonObject ensureInitialized() throws InterruptedException, IOException {
        if (this.initialized.compareAndSet(false, true)) {
            this.sseClient.connect(this.httpClient, Map.of());
            this.sseClient.awaitEndpoint();
            Integer initId = this.idGenerator.incrementAndGet();
            JsonObject initMessage = new JsonObject().put("jsonrpc", "2.0").put("id", initId).put("method", "initialize").put("params", new JsonObject().put("clientInfo", new JsonObject().put("name", "devui-client").put("version", "1.0")).put("protocolVersion", "2024-11-05"));
            HttpRequest request = HttpRequest.newBuilder().uri(this.messageEndpoint.get()).version(HttpClient.Version.HTTP_1_1).POST(HttpRequest.BodyPublishers.ofString(initMessage.encode())).build();
            HttpResponse<Void> response = this.httpClient.send(request, HttpResponse.BodyHandlers.discarding());
            if (response.statusCode() != 200) {
                return new JsonObject().put("error", "Init failed with invalid HTTP status: " + response.statusCode());
            }
            this.sseClient.awaitResponse(initId);
            JsonObject nofitication = new JsonObject().put("jsonrpc", "2.0").put("method", "notifications/initialized");
            request = HttpRequest.newBuilder().uri(this.messageEndpoint.get()).version(HttpClient.Version.HTTP_1_1).POST(HttpRequest.BodyPublishers.ofString(nofitication.encode())).build();
            response = this.httpClient.send(request, HttpResponse.BodyHandlers.discarding());
            if (response.statusCode() != 200) {
                return new JsonObject().put("error", "Init notification failed with invalid HTTP status: " + response.statusCode());
            }
        }
        return null;
    }

    private String pathToAppend(String prev, String path) {
        if (prev.endsWith("/")) {
            if (path.startsWith("/")) {
                return path.substring(1);
            }
            return path;
        }
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }

    class DevUISseClient
    extends SseClient {
        private static final int AWAIT_ATTEMPTS = 50;
        private static final int AWAIT_SLEEP = 100;
        private final CountDownLatch endpointLatch;
        private final ConcurrentMap<Integer, JsonObject> responses;

        public DevUISseClient(URI sseUri) {
            super(sseUri);
            this.endpointLatch = new CountDownLatch(1);
            this.responses = new ConcurrentHashMap<Integer, JsonObject>();
        }

        void awaitEndpoint() throws InterruptedException {
            if (!this.endpointLatch.await(10L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Endpoint not received");
            }
        }

        JsonObject awaitResponse(Integer id) throws InterruptedException {
            JsonObject response = (JsonObject)this.responses.get(id);
            int attempts = 0;
            while (response == null && attempts++ < 50) {
                TimeUnit.MILLISECONDS.sleep(100L);
                response = (JsonObject)this.responses.remove(id);
            }
            return response;
        }

        @Override
        protected void process(SseClient.SseEvent event) {
            JsonObject json;
            Integer id;
            if ("endpoint".equals(event.name())) {
                String endpoint = event.data().strip();
                SseMcpJsonRPCService.this.messageEndpoint.set(this.connectUri.resolve(endpoint));
                this.endpointLatch.countDown();
            } else if ("message".equals(event.name()) && (id = (json = new JsonObject(event.data())).getInteger("id")) != null && (json.containsKey("result") || json.containsKey("error"))) {
                this.responses.put(id, json);
            }
        }
    }
}

