/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime;

import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.runtime.BeanContainer;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

class BeanContainerImpl
implements BeanContainer {
    private static final Logger LOGGER = Logger.getLogger(BeanContainerImpl.class.getName());
    private final ArcContainer container;

    BeanContainerImpl(ArcContainer container) {
        this.container = container;
    }

    @Override
    public <T> T beanInstance(Class<T> beanType, Annotation ... beanQualifiers) {
        return this.container.select(beanType, beanQualifiers).get();
    }

    @Override
    public <T> BeanContainer.Factory<T> beanInstanceFactory(Class<T> type, Annotation ... qualifiers) {
        Supplier<InstanceHandle<T>> handleSupplier = this.container.beanInstanceSupplier(type, qualifiers);
        return this.createFactory(handleSupplier, null, type, qualifiers);
    }

    @Override
    public <T> BeanContainer.Factory<T> beanInstanceFactory(Supplier<BeanContainer.Factory<T>> fallbackSupplier, Class<T> type, Annotation ... qualifiers) {
        Supplier<InstanceHandle<T>> handleSupplier = this.container.beanInstanceSupplier(type, qualifiers);
        return this.createFactory(handleSupplier, fallbackSupplier, type, qualifiers);
    }

    private <T> BeanContainer.Factory<T> createFactory(final Supplier<InstanceHandle<T>> handleSupplier, Supplier<BeanContainer.Factory<T>> fallbackSupplier, Class<T> type, Annotation ... qualifiers) {
        if (handleSupplier == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debugf("No matching bean found for type %s and qualifiers %s. The bean might have been marked as unused and removed during build.", (Object)type, (Object)Arrays.toString(qualifiers));
            }
            if (fallbackSupplier != null) {
                return fallbackSupplier.get();
            }
            return new DefaultInstanceFactory<T>(type);
        }
        return new BeanContainer.Factory<T>(){

            @Override
            public BeanContainer.Instance<T> create() {
                final InstanceHandle handle = (InstanceHandle)handleSupplier.get();
                return new BeanContainer.Instance<T>(){

                    @Override
                    public T get() {
                        return handle.get();
                    }

                    @Override
                    public void close() {
                        handle.close();
                    }
                };
            }
        };
    }

    @Override
    public ManagedContext requestContext() {
        return this.container.requestContext();
    }

    private static final class DefaultInstanceFactory<T>
    implements BeanContainer.Factory<T> {
        private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
        private static final MethodType VOID_TYPE = MethodType.methodType(Void.TYPE);
        private final Class<T> type;

        DefaultInstanceFactory(Class<T> type) {
            this.type = type;
        }

        @Override
        public BeanContainer.Instance<T> create() {
            try {
                final Object instance = LOOKUP.findConstructor(this.type, VOID_TYPE).invoke();
                return new BeanContainer.Instance<T>(){

                    @Override
                    public T get() {
                        return instance;
                    }
                };
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
    }
}

