/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime;

import io.quarkus.devui.runtime.VertxRouteInfoService;
import io.vertx.core.Handler;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;

public class EndpointInfoHandler
implements Handler<RoutingContext> {
    private String basePath;
    private static final int STATUS = 200;
    private static final String OK = "OK";
    private static final String SLASH = "/";
    private static final String CONTENT_TYPE = "Content-Type";

    public EndpointInfoHandler() {
    }

    public EndpointInfoHandler(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public void handle(RoutingContext event) {
        String normalizedPath = event.normalizedPath();
        if (normalizedPath.contains(SLASH)) {
            int si = normalizedPath.lastIndexOf(SLASH) + 1;
            String path = normalizedPath.substring(0, si);
            String fileName = normalizedPath.substring(si);
            if (path.startsWith(this.basePath) && fileName.equals("routes.json")) {
                VertxRouteInfoService vertxRouteInfoService = (VertxRouteInfoService)CDI.current().select(VertxRouteInfoService.class, new Annotation[0]).get();
                JsonArray info = vertxRouteInfoService.getInfo();
                event.response().setStatusCode(200).setStatusMessage(OK).putHeader(CONTENT_TYPE, "application/json").end(Json.encodePrettily(info));
            } else {
                event.next();
            }
        } else {
            event.next();
        }
    }
}

