/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.config;

import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devui.runtime.config.ConfigDescription;
import io.quarkus.devui.runtime.config.ConfigDescriptionBean;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;

@ApplicationScoped
public class ConfigJsonRPCService {
    @Inject
    ConfigDescriptionBean configDescriptionBean;

    public JsonArray getAllConfiguration() {
        return new JsonArray(this.configDescriptionBean.getAllConfig());
    }

    public JsonObject getAllValues() {
        JsonObject values = new JsonObject();
        for (ConfigDescription configDescription : this.configDescriptionBean.getAllConfig()) {
            values.put(configDescription.getName(), configDescription.getConfigValue().getValue());
        }
        return values;
    }

    public JsonObject getProjectProperties() {
        JsonObject response = new JsonObject();
        try {
            List<Path> resourcesDir = DevConsoleManager.getHotReplacementContext().getResourcesDir();
            if (resourcesDir.isEmpty()) {
                response.put("error", "Unable to manage configurations - no resource directory found");
            } else {
                Path path = resourcesDir.get(0);
                Path configPropertiesPath = path.resolve("application.properties");
                if (Files.exists(configPropertiesPath, new LinkOption[0])) {
                    response.put("type", "properties");
                    String value = new String(Files.readAllBytes(configPropertiesPath));
                    response.put("value", value);
                } else {
                    response.put("type", "properties");
                    response.put("value", "");
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return response;
    }
}

