/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.continuoustesting;

import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.testing.ContinuousTestingSharedStateManager;
import io.quarkus.dev.testing.results.TestResultInterface;
import io.quarkus.dev.testing.results.TestRunResultsInterface;
import io.quarkus.devui.runtime.continuoustesting.ContinuousTestingJsonRPCState;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.function.Consumer;

@ApplicationScoped
public class ContinuousTestingJsonRPCService
implements Consumer<ContinuousTestingSharedStateManager.State> {
    private final BroadcastProcessor<ContinuousTestingJsonRPCState> stateBroadcaster = BroadcastProcessor.create();
    private ContinuousTestingJsonRPCState currentState = new ContinuousTestingJsonRPCState();

    @Override
    public void accept(ContinuousTestingSharedStateManager.State state) {
        TestRunResultsInterface results = (TestRunResultsInterface)DevConsoleManager.invoke("devui-continuous-testing.getResults");
        LinkedList passedTests = new LinkedList();
        LinkedList failedTests = new LinkedList();
        LinkedList skippedTests = new LinkedList();
        TreeSet tags = new TreeSet();
        if (null != results) {
            results.getResults().values().stream().flatMap(result -> result.getResults().stream()).filter(TestResultInterface::isTest).sorted(Comparator.comparing(TestResultInterface::getTestClass).thenComparing(TestResultInterface::getDisplayName).thenComparing(TestResultInterface::getDisplayName)).forEach(result -> {
                (switch (result.getState()) {
                    default -> throw new IncompatibleClassChangeError();
                    case TestResultInterface.State.PASSED -> passedTests;
                    case TestResultInterface.State.FAILED -> failedTests;
                    case TestResultInterface.State.SKIPPED -> skippedTests;
                }).add(new ContinuousTestingJsonRPCState.Result.Item().setClassName(result.getTestClass()).setDisplayName(result.getDisplayName()).setProblems(result.getProblems().toArray(new Throwable[0])).setTime(result.getTime()).setTags(result.getTags().toArray(new String[0])));
                tags.addAll(result.getTags());
            });
        }
        this.currentState = new ContinuousTestingJsonRPCState().setInProgress(state.inProgress).setConfig(new ContinuousTestingJsonRPCState.Config().setEnabled(state.running).setBrokenOnly(state.isBrokenOnly)).setResult(new ContinuousTestingJsonRPCState.Result().setCounts(new ContinuousTestingJsonRPCState.Result.Counts().setPassed(state.passed).setFailed(state.failed).setSkipped(state.skipped)).setTags(tags.toArray(new String[0])).setTotalTime(results == null ? 0L : results.getTotalTime()).setPassed(passedTests.toArray(new ContinuousTestingJsonRPCState.Result.Item[0])).setFailed(failedTests.toArray(new ContinuousTestingJsonRPCState.Result.Item[0])).setSkipped(skippedTests.toArray(new ContinuousTestingJsonRPCState.Result.Item[0])));
        this.stateBroadcaster.onNext(this.currentState);
    }

    public Multi<ContinuousTestingJsonRPCState> streamState() {
        return this.stateBroadcaster;
    }

    @NonBlocking
    public ContinuousTestingJsonRPCState currentState() {
        return this.currentState;
    }
}

