/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.logstream;

import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.concurrent.LinkedBlockingQueue;

@ApplicationScoped
public class LogStreamBroadcaster {
    private final LinkedBlockingQueue<JsonObject> history = new LinkedBlockingQueue(60);
    private final BroadcastProcessor<JsonObject> logStream = BroadcastProcessor.create();

    public BroadcastProcessor<JsonObject> getLogStream() {
        return this.logStream;
    }

    public void onNext(JsonObject message) {
        this.recordHistory(message);
        this.logStream.onNext(message);
    }

    public LinkedBlockingQueue<JsonObject> getHistory() {
        return this.history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordHistory(JsonObject message) {
        LogStreamBroadcaster logStreamBroadcaster = this;
        synchronized (logStreamBroadcaster) {
            try {
                if (this.history.remainingCapacity() == 0) {
                    this.history.take();
                }
                this.history.add(message);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

