/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.logstream;

import io.quarkus.arc.Arc;
import io.quarkus.devui.runtime.logstream.JsonFormatter;
import io.quarkus.devui.runtime.logstream.LogStreamBroadcaster;
import io.quarkus.runtime.logging.DecorateStackUtil;
import io.vertx.core.json.JsonObject;
import java.lang.annotation.Annotation;
import java.util.List;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;

public class MutinyLogHandler
extends ExtHandler {
    private LogStreamBroadcaster logStreamBroadcaster;
    private final boolean decorateStack;
    private final String srcMainJava;
    private final List<String> knownClasses;

    public MutinyLogHandler(boolean decorateStack, String srcMainJava, List<String> knownClasses) {
        this.decorateStack = decorateStack;
        this.srcMainJava = srcMainJava;
        this.knownClasses = knownClasses;
        this.setFormatter(new JsonFormatter());
    }

    @Override
    public final void doPublish(ExtLogRecord record) {
        LogStreamBroadcaster broadcaster;
        if (record.getMessage() == null || record.getMessage().isEmpty()) {
            return;
        }
        if (this.isLoggable(record) && (broadcaster = this.getBroadcaster()) != null) {
            String decoratedString;
            JsonObject message = ((JsonFormatter)this.getFormatter()).toJsonObject(record);
            if (this.decorateStack && (decoratedString = DecorateStackUtil.getDecoratedString(record.getThrown(), this.srcMainJava, this.knownClasses)) != null) {
                message.put("decoration", decoratedString);
            }
            broadcaster.onNext(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogStreamBroadcaster getBroadcaster() {
        MutinyLogHandler mutinyLogHandler = this;
        synchronized (mutinyLogHandler) {
            if (this.logStreamBroadcaster == null && Arc.container() != null) {
                this.logStreamBroadcaster = Arc.container().instance(LogStreamBroadcaster.class, new Annotation[0]).get();
            }
        }
        return this.logStreamBroadcaster;
    }
}

