/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jackson.customizer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.quarkus.jackson.ObjectMapperCustomizer;
import io.quarkus.vertx.runtime.jackson.JsonArrayDeserializer;
import io.quarkus.vertx.runtime.jackson.JsonArraySerializer;
import io.quarkus.vertx.runtime.jackson.JsonObjectDeserializer;
import io.quarkus.vertx.runtime.jackson.JsonObjectSerializer;
import jakarta.inject.Singleton;

@Singleton
public class RegisterSerializersAndDeserializersCustomizer
implements ObjectMapperCustomizer {
    @Override
    public void customize(ObjectMapper objectMapper) {
        SimpleModule simpleModule = new SimpleModule("VertxTypes");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = Class.forName("io.vertx.core.json.JsonArray", false, classLoader);
        JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();
        simpleModule.addSerializer(clazz, jsonArraySerializer);
        JsonArrayDeserializer jsonArrayDeserializer = new JsonArrayDeserializer();
        simpleModule.addDeserializer(clazz, jsonArrayDeserializer);
        Class<?> clazz2 = Class.forName("io.vertx.core.json.JsonObject", false, classLoader);
        JsonObjectSerializer jsonObjectSerializer = new JsonObjectSerializer();
        simpleModule.addSerializer(clazz2, jsonObjectSerializer);
        JsonObjectDeserializer jsonObjectDeserializer = new JsonObjectDeserializer();
        simpleModule.addDeserializer(clazz2, jsonObjectDeserializer);
        objectMapper.registerModule(simpleModule);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        objectMapper.registerModule(javaTimeModule);
        Jdk8Module jdk8Module = new Jdk8Module();
        objectMapper.registerModule(jdk8Module);
        ParameterNamesModule parameterNamesModule = new ParameterNamesModule();
        objectMapper.registerModule(parameterNamesModule);
    }

    @Override
    public int priority() {
        return -2147483548;
    }
}

