/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mutiny.runtime;

import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.jboss.threads.ContextHandler;

@Recorder
public class MutinyInfrastructure {
    public static final String VERTX_EVENT_LOOP_THREAD_PREFIX = "vert.x-eventloop-thread-";

    public void configureMutinyInfrastructure(ScheduledExecutorService executor, ShutdownContext shutdownContext, ContextHandler<Object> contextHandler) {
        Infrastructure.getDefaultWorkerPool().shutdown();
        Infrastructure.setDefaultExecutor(executor);
    }

    public void configureDroppedExceptionHandler() {
        final Logger logger2 = Logger.getLogger(MutinyInfrastructure.class);
        Infrastructure.setDroppedExceptionHandler(new Consumer<Throwable>(){

            @Override
            public void accept(Throwable throwable) {
                logger2.error((Object)"Mutiny had to drop the following exception", throwable);
            }
        });
    }

    public void configureThreadBlockingChecker() {
        Infrastructure.setCanCallerThreadBeBlockedSupplier(new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                String threadName = Thread.currentThread().getName();
                return !threadName.startsWith(MutinyInfrastructure.VERTX_EVENT_LOOP_THREAD_PREFIX);
            }
        });
    }

    public void configureOperatorLogger() {
        final Logger logger2 = Logger.getLogger(MutinyInfrastructure.class);
        Infrastructure.setOperatorLogger(new Infrastructure.OperatorLogger(){

            @Override
            public void log(String identifier, String event, Object value, Throwable failure) {
                String log = identifier + " | ";
                log = failure != null ? log + event + "(" + String.valueOf(failure.getClass()) + "(" + failure.getMessage() + "))" : (value != null ? log + event + "(" + String.valueOf(value) + ")" : log + event + "()");
                logger2.info(log);
            }
        });
    }
}

