/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.netty.runtime.virtual;

import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.quarkus.netty.runtime.virtual.VirtualAddress;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentMap;

final class VirtualChannelRegistry {
    private static final ConcurrentMap<VirtualAddress, Channel> boundChannels = PlatformDependent.newConcurrentHashMap();

    static VirtualAddress register(Channel channel, VirtualAddress oldLocalAddress, SocketAddress localAddress) {
        Channel boundChannel;
        if (oldLocalAddress != null) {
            throw new ChannelException("already bound");
        }
        if (!(localAddress instanceof VirtualAddress)) {
            throw new ChannelException("unsupported address type: " + StringUtil.simpleClassName(localAddress));
        }
        VirtualAddress addr = (VirtualAddress)localAddress;
        if (VirtualAddress.ANY.equals(addr)) {
            addr = new VirtualAddress(channel);
        }
        if ((boundChannel = boundChannels.putIfAbsent(addr, channel)) != null) {
            throw new ChannelException("address already in use by: " + String.valueOf(boundChannel));
        }
        return addr;
    }

    static Channel get(SocketAddress localAddress) {
        return (Channel)boundChannels.get(localAddress);
    }

    static void unregister(VirtualAddress localAddress) {
        boundChannels.remove(localAddress);
    }

    private VirtualChannelRegistry() {
    }
}

