/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.JavaScriptRequestChecker;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.TenantConfigResolver;
import io.quarkus.oidc.TenantResolver;
import io.quarkus.oidc.TokenIntrospectionCache;
import io.quarkus.oidc.TokenStateManager;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.UserInfoCache;
import io.quarkus.oidc.runtime.BackChannelLogoutTokenCache;
import io.quarkus.oidc.runtime.BlockingTaskRunner;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.StaticTenantResolver;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@ApplicationScoped
public class DefaultTenantConfigResolver {
    private static final Logger LOG = Logger.getLogger(DefaultTenantConfigResolver.class);
    private static final String CURRENT_STATIC_TENANT_ID = "static.tenant.id";
    private static final String CURRENT_STATIC_TENANT_ID_NULL = "static.tenant.id.null";
    private static final String CURRENT_DYNAMIC_TENANT_CONFIG = "dynamic.tenant.config";
    private final ConcurrentHashMap<String, BackChannelLogoutTokenCache> backChannelLogoutTokens;
    private final BlockingTaskRunner<OidcTenantConfig> blockingRequestContext;
    private final boolean securityEventObserved;
    private final TenantConfigBean tenantConfigBean;
    private final boolean annotationBasedTenantResolutionEnabled;
    private final String rootPath;
    private final StaticTenantResolver staticTenantResolver;
    @Inject
    Instance<TenantConfigResolver> tenantConfigResolver;
    @Inject
    Instance<JavaScriptRequestChecker> javaScriptRequestChecker;
    @Inject
    Instance<TokenStateManager> tokenStateManager;
    @Inject
    Instance<TokenIntrospectionCache> tokenIntrospectionCache;
    @Inject
    Instance<UserInfoCache> userInfoCache;
    @Inject
    Event<SecurityEvent> securityEvent;
    @Inject
    @ConfigProperty(name="quarkus.http.proxy.enable-forwarded-prefix")
    boolean enableHttpForwardedPrefix;

    DefaultTenantConfigResolver(BlockingSecurityExecutor blockingExecutor, BeanManager beanManager, Instance<TenantResolver> tenantResolverInstance, @ConfigProperty(name="quarkus.oidc.resolve-tenants-with-issuer") boolean resolveTenantsWithIssuer, @ConfigProperty(name="quarkus.security.events.enabled") boolean securityEventsEnabled, @ConfigProperty(name="quarkus.http.root-path") String rootPath, TenantConfigBean tenantConfigBean) {
        this.backChannelLogoutTokens = new ConcurrentHashMap();
        this.blockingRequestContext = new BlockingTaskRunner(blockingExecutor);
        this.securityEventObserved = SecurityEventHelper.isEventObserved(new SecurityEvent(null, (SecurityIdentity)null), beanManager, securityEventsEnabled);
        this.tenantConfigBean = tenantConfigBean;
        this.annotationBasedTenantResolutionEnabled = Boolean.getBoolean("io.quarkus.oidc.runtime.select-tenants-with-annotation");
        this.rootPath = rootPath;
        this.staticTenantResolver = new StaticTenantResolver(tenantConfigBean, rootPath, resolveTenantsWithIssuer, tenantResolverInstance);
    }

    @PostConstruct
    public void verifyResolvers() {
        if (this.tenantConfigResolver.isResolvable() && this.tenantConfigResolver.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + String.valueOf(TenantConfigResolver.class) + " beans registered");
        }
        if (this.tokenStateManager.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + String.valueOf(TokenStateManager.class) + " beans registered");
        }
        if (this.tokenIntrospectionCache.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + String.valueOf(TokenIntrospectionCache.class) + " beans registered");
        }
        if (this.userInfoCache.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + String.valueOf(UserInfo.class) + " beans registered");
        }
        if (this.javaScriptRequestChecker.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + String.valueOf(JavaScriptRequestChecker.class) + " beans registered");
        }
    }

    Uni<OidcTenantConfig> resolveConfig(final RoutingContext context) {
        return this.getDynamicTenantConfig(context).flatMap(new Function<OidcTenantConfig, Uni<? extends OidcTenantConfig>>(){

            @Override
            public Uni<OidcTenantConfig> apply(OidcTenantConfig oidcTenantConfig) {
                TenantConfigContext tenantContext;
                if (oidcTenantConfig != null) {
                    return Uni.createFrom().item(oidcTenantConfig);
                }
                String tenantId = (String)context.get("tenant-id");
                if (tenantId != null && !DefaultTenantConfigResolver.this.isTenantSetByAnnotation(context, tenantId) && (tenantContext = DefaultTenantConfigResolver.this.tenantConfigBean.getDynamicTenant(tenantId)) != null) {
                    return Uni.createFrom().item(tenantContext.getOidcTenantConfig());
                }
                return DefaultTenantConfigResolver.this.getStaticTenantContext(context).onItem().ifNotNull().transform(TenantConfigContext::getOidcTenantConfig);
            }
        });
    }

    Uni<TenantConfigContext> resolveContext(String tenantId) {
        return this.initializeStaticTenantIfContextNotReady(this.getStaticTenantContext(tenantId));
    }

    Uni<TenantConfigContext> resolveContext(final RoutingContext context) {
        return this.getDynamicTenantContext(context).flatMap(new Function<TenantConfigContext, Uni<? extends TenantConfigContext>>(){

            @Override
            public Uni<? extends TenantConfigContext> apply(TenantConfigContext tenantConfigContext) {
                if (tenantConfigContext != null) {
                    return Uni.createFrom().item(tenantConfigContext);
                }
                return DefaultTenantConfigResolver.this.getStaticTenantContext(context).flatMap(DefaultTenantConfigResolver.this::initializeStaticTenantIfContextNotReady);
            }
        });
    }

    private Uni<TenantConfigContext> initializeStaticTenantIfContextNotReady(TenantConfigContext tenantContext) {
        if (tenantContext != null && !tenantContext.ready()) {
            return tenantContext.initialize();
        }
        return Uni.createFrom().item(tenantContext);
    }

    private Uni<TenantConfigContext> getStaticTenantContext(final RoutingContext context) {
        String tenantId = (String)context.get(CURRENT_STATIC_TENANT_ID);
        if (tenantId != null) {
            return Uni.createFrom().item(this.getStaticTenantContext(tenantId));
        }
        if (context.get(CURRENT_STATIC_TENANT_ID_NULL) == null) {
            return this.resolveStaticTenantId(context).map(new Function<String, TenantConfigContext>(){

                @Override
                public TenantConfigContext apply(String tenantId) {
                    if (tenantId != null) {
                        context.put(DefaultTenantConfigResolver.CURRENT_STATIC_TENANT_ID, tenantId);
                    } else {
                        context.put(DefaultTenantConfigResolver.CURRENT_STATIC_TENANT_ID_NULL, true);
                    }
                    return DefaultTenantConfigResolver.this.getStaticTenantContext(tenantId);
                }
            });
        }
        return Uni.createFrom().item(this.getStaticTenantContext((String)null));
    }

    private Uni<String> resolveStaticTenantId(final RoutingContext context) {
        String tenantId = (String)context.get("tenant-id");
        if (this.isTenantSetByAnnotation(context, tenantId)) {
            return Uni.createFrom().item(tenantId);
        }
        return this.staticTenantResolver.resolve(context).map(new Function<String, String>(){

            @Override
            public String apply(String tenantId) {
                if (tenantId == null) {
                    return (String)context.get("tenant-id");
                }
                return tenantId;
            }
        });
    }

    private boolean isTenantSetByAnnotation(RoutingContext context, String tenantId) {
        return this.annotationBasedTenantResolutionEnabled && tenantId != null && context.get("tenant-id-set-by-annotation") != null;
    }

    private TenantConfigContext getStaticTenantContext(String tenantId) {
        TenantConfigContext configContext;
        TenantConfigContext tenantConfigContext = configContext = tenantId != null ? this.tenantConfigBean.getStaticTenant(tenantId) : null;
        if (configContext == null) {
            if (tenantId != null && !tenantId.isEmpty() && !"Default".equals(tenantId)) {
                LOG.debugf("Registered TenantResolver has not provided the configuration for tenant '%s', using the default tenant", (Object)tenantId);
            }
            configContext = this.tenantConfigBean.getDefaultTenant();
        }
        return configContext;
    }

    boolean isSecurityEventObserved() {
        return this.securityEventObserved;
    }

    Event<SecurityEvent> getSecurityEvent() {
        return this.securityEvent;
    }

    TokenStateManager getTokenStateManager() {
        return (TokenStateManager)this.tokenStateManager.get();
    }

    TokenIntrospectionCache getTokenIntrospectionCache() {
        return this.tokenIntrospectionCache.isResolvable() ? (TokenIntrospectionCache)this.tokenIntrospectionCache.get() : null;
    }

    UserInfoCache getUserInfoCache() {
        return this.userInfoCache.isResolvable() ? (UserInfoCache)this.userInfoCache.get() : null;
    }

    private Uni<OidcTenantConfig> getDynamicTenantConfig(RoutingContext context) {
        if (this.isTenantSetByAnnotation(context, (String)context.get("tenant-id"))) {
            return Uni.createFrom().nullItem();
        }
        if (this.tenantConfigResolver.isResolvable()) {
            Uni<OidcTenantConfig> oidcConfig = (Uni<OidcTenantConfig>)context.get(CURRENT_DYNAMIC_TENANT_CONFIG);
            if (oidcConfig == null) {
                oidcConfig = ((TenantConfigResolver)this.tenantConfigResolver.get()).resolve(context, this.blockingRequestContext);
                if (oidcConfig == null) {
                    oidcConfig = Uni.createFrom().nullItem();
                }
                oidcConfig = (oidcConfig = oidcConfig.memoize().indefinitely()) == null ? Uni.createFrom().nullItem() : oidcConfig.onItem().transform(cfg -> OidcUtils.resolveProviderConfig(cfg));
                context.put(CURRENT_DYNAMIC_TENANT_CONFIG, oidcConfig);
            }
            return oidcConfig;
        }
        return Uni.createFrom().nullItem();
    }

    private Uni<TenantConfigContext> getDynamicTenantContext(final RoutingContext context) {
        return this.getDynamicTenantConfig(context).chain(new Function<OidcTenantConfig, Uni<? extends TenantConfigContext>>(){

            @Override
            public Uni<? extends TenantConfigContext> apply(OidcTenantConfig tenantConfig) {
                TenantConfigContext tenantContext;
                if (tenantConfig != null) {
                    String tenantId = tenantConfig.getTenantId().orElseThrow(() -> new OIDCException("Tenant configuration must have tenant id"));
                    TenantConfigContext tenantContext2 = DefaultTenantConfigResolver.this.tenantConfigBean.getDynamicTenant(tenantId);
                    if (tenantContext2 == null) {
                        return DefaultTenantConfigResolver.this.tenantConfigBean.createDynamicTenantContext(tenantConfig);
                    }
                    return Uni.createFrom().item(tenantContext2);
                }
                String tenantId = (String)context.get("tenant-id");
                if (tenantId != null && !DefaultTenantConfigResolver.this.isTenantSetByAnnotation(context, tenantId) && (tenantContext = DefaultTenantConfigResolver.this.tenantConfigBean.getDynamicTenant(tenantId)) != null) {
                    return Uni.createFrom().item(tenantContext);
                }
                return Uni.createFrom().nullItem();
            }
        });
    }

    boolean isEnableHttpForwardedPrefix() {
        return this.enableHttpForwardedPrefix;
    }

    public Map<String, BackChannelLogoutTokenCache> getBackChannelLogoutTokens() {
        return this.backChannelLogoutTokens;
    }

    public TenantConfigBean getTenantConfigBean() {
        return this.tenantConfigBean;
    }

    public JavaScriptRequestChecker getJavaScriptRequestChecker() {
        return this.javaScriptRequestChecker.isResolvable() ? (JavaScriptRequestChecker)this.javaScriptRequestChecker.get() : null;
    }

    public OidcTenantConfig getResolvedConfig(String sessionTenantId) {
        if ("Default".equals(sessionTenantId)) {
            return this.tenantConfigBean.getDefaultTenant().getOidcTenantConfig();
        }
        TenantConfigContext tenant = this.tenantConfigBean.getStaticTenant(sessionTenantId);
        if (tenant == null) {
            tenant = this.tenantConfigBean.getDynamicTenant(sessionTenantId);
        }
        return tenant != null ? tenant.getOidcTenantConfig() : null;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public DefaultTenantConfigResolver() {
    }
}

