/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.common.runtime.config.OidcClientCommonConfig;
import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.configuration.TrimmedStringConverter;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

public interface OidcTenantConfig
extends OidcClientCommonConfig {
    public Optional<String> tenantId();

    @WithDefault(value="true")
    public boolean tenantEnabled();

    @ConfigDocDefault(value="service")
    public Optional<ApplicationType> applicationType();

    public Optional<String> authorizationPath();

    public Optional<String> userInfoPath();

    public Optional<String> introspectionPath();

    public Optional<String> jwksPath();

    public Optional<String> endSessionPath();

    public Optional<List<String>> tenantPaths();

    public Optional<String> publicKey();

    @ConfigDocSection
    public IntrospectionCredentials introspectionCredentials();

    @ConfigDocSection
    public Roles roles();

    @ConfigDocSection
    public Token token();

    @ConfigDocSection
    public Logout logout();

    @ConfigDocSection
    public CertificateChain certificateChain();

    @ConfigDocSection
    public Authentication authentication();

    @ConfigDocSection
    public CodeGrant codeGrant();

    @ConfigDocSection
    public TokenStateManager tokenStateManager();

    @WithDefault(value="true")
    public boolean allowTokenIntrospectionCache();

    @WithDefault(value="true")
    public boolean allowUserInfoCache();

    public Optional<Boolean> cacheUserInfoInIdtoken();

    @ConfigDocSection
    public Jwks jwks();

    public Optional<Provider> provider();

    public static enum Provider {
        APPLE,
        DISCORD,
        FACEBOOK,
        GITHUB,
        GOOGLE,
        LINKEDIN,
        MASTODON,
        MICROSOFT,
        SLACK,
        SPOTIFY,
        STRAVA,
        TWITCH,
        TWITTER,
        X;

    }

    public static enum ApplicationType {
        WEB_APP,
        SERVICE,
        HYBRID;

    }

    public static interface Binding {
        @WithDefault(value="false")
        public boolean certificate();
    }

    public static interface Token {
        public Optional<String> issuer();

        public Optional<List<String>> audience();

        @WithDefault(value="false")
        public boolean subjectRequired();

        @ConfigDocMapKey(value="claim-name")
        public Map<String, String> requiredClaims();

        public Optional<String> tokenType();

        public OptionalInt lifespanGrace();

        public Optional<Duration> age();

        @WithDefault(value="true")
        public boolean issuedAtRequired();

        public Optional<String> principalClaim();

        @WithDefault(value="false")
        public boolean refreshExpired();

        public Optional<Duration> refreshTokenTimeSkew();

        @WithDefault(value="10M")
        public Duration forcedJwkRefreshInterval();

        public Optional<String> header();

        @WithDefault(value="Bearer")
        public String authorizationScheme();

        public Optional<SignatureAlgorithm> signatureAlgorithm();

        public Optional<String> decryptionKeyLocation();

        @WithDefault(value="true")
        public boolean allowJwtIntrospection();

        @WithDefault(value="false")
        public boolean requireJwtIntrospectionOnly();

        @WithDefault(value="true")
        public boolean allowOpaqueTokenIntrospection();

        public Optional<String> customizerName();

        @ConfigDocDefault(value="false")
        public Optional<Boolean> verifyAccessTokenWithUserInfo();

        public Binding binding();
    }

    public static enum SignatureAlgorithm {
        RS256,
        RS384,
        RS512,
        PS256,
        PS384,
        PS512,
        ES256,
        ES384,
        ES512,
        EDDSA;

        private static String EDDSA_ALG;
        private static String REQUIRED_EDDSA_ALG;

        public String getAlgorithm() {
            String name = this.name();
            return EDDSA_ALG.equals(name) ? REQUIRED_EDDSA_ALG : name;
        }

        static {
            EDDSA_ALG = "EDDSA";
            REQUIRED_EDDSA_ALG = "EdDSA";
        }
    }

    public static interface CodeGrant {
        @ConfigDocMapKey(value="parameter-name")
        public Map<String, String> extraParams();

        @ConfigDocMapKey(value="header-name")
        public Map<String, String> headers();
    }

    public static interface Authentication {
        @ConfigDocDefault(value="query")
        public Optional<ResponseMode> responseMode();

        public Optional<String> redirectPath();

        @WithDefault(value="false")
        public boolean restorePathAfterRedirect();

        @WithDefault(value="true")
        public boolean removeRedirectParameters();

        public Optional<String> errorPath();

        public Optional<String> sessionExpiredPath();

        @ConfigDocDefault(value="true when access token is injected as the JsonWebToken bean, false otherwise")
        @WithDefault(value="false")
        public boolean verifyAccessToken();

        @ConfigDocDefault(value="false")
        public Optional<Boolean> forceRedirectHttpsScheme();

        public Optional<List<String>> scopes();

        public Optional<String> scopeSeparator();

        @WithDefault(value="false")
        public boolean nonceRequired();

        @ConfigDocDefault(value="true")
        public Optional<Boolean> addOpenidScope();

        @ConfigDocMapKey(value="parameter-name")
        public Map<String, String> extraParams();

        public Optional<@WithConverter(value=TrimmedStringConverter.class) List<String>> forwardParams();

        @WithDefault(value="false")
        public boolean cookieForceSecure();

        public Optional<String> cookieSuffix();

        @WithDefault(value="/")
        public String cookiePath();

        public Optional<String> cookiePathHeader();

        public Optional<String> cookieDomain();

        @WithDefault(value="lax")
        public CookieSameSite cookieSameSite();

        @WithDefault(value="true")
        public boolean allowMultipleCodeFlows();

        @WithDefault(value="false")
        public boolean failOnMissingStateParam();

        @ConfigDocDefault(value="true when UserInfo bean is injected, false otherwise")
        public Optional<Boolean> userInfoRequired();

        @WithDefault(value="5M")
        public Duration sessionAgeExtension();

        @WithDefault(value="5M")
        public Duration stateCookieAge();

        @WithDefault(value="true")
        public boolean javaScriptAutoRedirect();

        @ConfigDocDefault(value="true")
        public Optional<Boolean> idTokenRequired();

        public Optional<Duration> internalIdTokenLifespan();

        @ConfigDocDefault(value="false")
        public Optional<Boolean> pkceRequired();

        @Deprecated(forRemoval=true)
        public Optional<String> pkceSecret();

        public Optional<String> stateSecret();

        public static enum ResponseMode {
            QUERY,
            FORM_POST;

        }

        public static enum CookieSameSite {
            STRICT,
            LAX,
            NONE;

        }
    }

    public static interface Roles {
        public Optional<List<String>> roleClaimPath();

        public Optional<String> roleClaimSeparator();

        public Optional<Source> source();

        public static enum Source {
            idtoken,
            accesstoken,
            userinfo;

        }
    }

    public static interface TokenStateManager {
        @WithDefault(value="keep_all_tokens")
        public Strategy strategy();

        @WithDefault(value="false")
        public boolean splitTokens();

        @WithDefault(value="true")
        public boolean encryptionRequired();

        public Optional<String> encryptionSecret();

        @WithDefault(value="A256GCMKW")
        public EncryptionAlgorithm encryptionAlgorithm();

        public static enum EncryptionAlgorithm {
            A256GCMKW,
            DIR;

        }

        public static enum Strategy {
            KEEP_ALL_TOKENS,
            ID_TOKEN,
            ID_REFRESH_TOKENS;

        }
    }

    public static interface Frontchannel {
        public Optional<String> path();
    }

    public static interface Jwks {
        @WithDefault(value="true")
        public boolean resolveEarly();

        @WithDefault(value="10")
        public int cacheSize();

        @WithDefault(value="10M")
        public Duration cacheTimeToLive();

        public Optional<Duration> cleanUpTimerInterval();

        @WithDefault(value="false")
        public boolean tryAll();
    }

    public static interface Backchannel {
        public Optional<String> path();

        @WithDefault(value="10")
        public int tokenCacheSize();

        @WithDefault(value="10M")
        public Duration tokenCacheTimeToLive();

        public Optional<Duration> cleanUpTimerInterval();

        @WithDefault(value="sub")
        public String logoutTokenKey();
    }

    public static interface Logout {
        public Optional<String> path();

        public Optional<String> postLogoutPath();

        @WithDefault(value="post_logout_redirect_uri")
        public String postLogoutUriParam();

        @ConfigDocMapKey(value="query-parameter-name")
        public Map<String, String> extraParams();

        public Backchannel backchannel();

        public Frontchannel frontchannel();
    }

    public static interface CertificateChain {
        public Optional<String> leafCertificateName();

        public Optional<Path> trustStoreFile();

        public Optional<String> trustStorePassword();

        public Optional<String> trustStoreCertAlias();

        public Optional<String> trustStoreFileType();
    }

    public static interface IntrospectionCredentials {
        public Optional<String> name();

        public Optional<String> secret();

        @WithDefault(value="true")
        public boolean includeClientId();
    }
}

