/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.runtime.configuration.ConfigBuilder;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.util.Iterator;
import java.util.OptionalInt;

public class OidcTenantDefaultIdConfigBuilder
implements ConfigBuilder {
    private static final String OIDC_PREFIX = "quarkus.oidc.";
    private static final String TENANT_ID_POSTFIX = ".tenant-id";
    private static final String DEFAULT_TENANT_ID_PROPERTY_KEY = "quarkus.oidc.tenant-id";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String WITH_DEFAULTS_ID_KEY = "quarkus.oidc.*.tenant-id";

    @Override
    public SmallRyeConfigBuilder configBuilder(SmallRyeConfigBuilder builder) {
        final ConfigSourceInterceptor configSourceInterceptor = OidcTenantDefaultIdConfigBuilder.createConfigSourceInterceptor();
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory(){

            @Override
            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext configSourceInterceptorContext) {
                return configSourceInterceptor;
            }

            @Override
            public OptionalInt getPriority() {
                return OptionalInt.of(3200);
            }
        });
        return builder;
    }

    @Override
    public int priority() {
        return Integer.MIN_VALUE;
    }

    private static boolean isNotSet(ConfigValue configValue) {
        return configValue == null || configValue.getValue() == null || configValue.getValue().isEmpty();
    }

    private static ConfigValue createConfigValue(String name, String value) {
        return ConfigValue.builder().withName(name).withValue(value).build();
    }

    private static ConfigSourceInterceptor createConfigSourceInterceptor() {
        return new ConfigSourceInterceptor(){

            @Override
            public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
                ConfigValue configValue = context.proceed(name);
                if (OidcTenantDefaultIdConfigBuilder.isNotSet(configValue) && name.startsWith(OidcTenantDefaultIdConfigBuilder.OIDC_PREFIX) && name.endsWith(OidcTenantDefaultIdConfigBuilder.TENANT_ID_POSTFIX) && !OidcTenantDefaultIdConfigBuilder.WITH_DEFAULTS_ID_KEY.equals(name)) {
                    if (name.equals(OidcTenantDefaultIdConfigBuilder.DEFAULT_TENANT_ID_PROPERTY_KEY)) {
                        return OidcTenantDefaultIdConfigBuilder.createConfigValue(name, "Default");
                    }
                    String maybeTenantName = name.substring(OidcTenantDefaultIdConfigBuilder.OIDC_PREFIX.length(), name.length() - OidcTenantDefaultIdConfigBuilder.TENANT_ID_POSTFIX.length());
                    if (maybeTenantName.startsWith(OidcTenantDefaultIdConfigBuilder.DOUBLE_QUOTE) && maybeTenantName.endsWith(OidcTenantDefaultIdConfigBuilder.DOUBLE_QUOTE)) {
                        String tenantNameWithoutQuotes = maybeTenantName.substring(1, maybeTenantName.length() - 1);
                        return OidcTenantDefaultIdConfigBuilder.createConfigValue(name, tenantNameWithoutQuotes);
                    }
                    if (!maybeTenantName.contains(".")) {
                        return OidcTenantDefaultIdConfigBuilder.createConfigValue(name, maybeTenantName);
                    }
                }
                return configValue;
            }

            @Override
            public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
                return context.iterateNames();
            }
        };
    }
}

