/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.runtime.util.ClassPathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jose4j.keys.X509Util;

public class TrustStoreUtils {
    private static final Logger LOGGER = Logger.getLogger(TrustStoreUtils.class.getName());

    public static Set<String> getTrustedCertificateThumbprints(Path path, String trustStoreSecret, Optional<String> trustStoreCertAlias, Optional<String> trustStoreFileType) {
        URL trustStoreFileUrl = null;
        trustStoreFileUrl = Thread.currentThread().getContextClassLoader().getResource(ClassPathUtils.toResourceName(path));
        if (trustStoreFileUrl != null) {
            return TrustStoreUtils.readTrustStore(path, trustStoreFileUrl, trustStoreSecret, trustStoreCertAlias, trustStoreFileType);
        }
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return TrustStoreUtils.readTrustStore(path, path.toUri().toURL(), trustStoreSecret, trustStoreCertAlias, trustStoreFileType);
            }
            catch (MalformedURLException e) {
                LOGGER.errorf("Keystore %s location is not a valid URL", (Object)path.toUri());
                throw new RuntimeException(e);
            }
        }
        LOGGER.errorf("Keystore %s can not be found on the classpath and the file system", (Object)path.toUri());
        throw new RuntimeException();
    }

    private static Set<String> readTrustStore(Path path, URL trustStoreFileUrl, String trustStoreSecret, Optional<String> trustStoreCertAlias, Optional<String> trustStoreFileType) {
        HashSet<String> hashSet;
        block13: {
            InputStream fis = trustStoreFileUrl.openStream();
            try {
                KeyStore keyStore = KeyStore.getInstance(OidcCommonUtils.getKeyStoreType(trustStoreFileType, path));
                keyStore.load(fis, trustStoreSecret.toCharArray());
                HashSet<String> allThumbprints = new HashSet<String>();
                if (trustStoreCertAlias.isPresent()) {
                    TrustStoreUtils.addThumbprints(keyStore, allThumbprints, trustStoreCertAlias.get());
                } else {
                    Enumeration<String> aliases = keyStore.aliases();
                    while (aliases.hasMoreElements()) {
                        TrustStoreUtils.addThumbprints(keyStore, allThumbprints, aliases.nextElement());
                    }
                }
                if (allThumbprints.isEmpty()) {
                    LOGGER.errorf("Keystore %s entries can not be loaded", (Object)trustStoreFileUrl.toString());
                    throw new RuntimeException();
                }
                hashSet = allThumbprints;
                if (fis == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.errorf("Keystore %s can not be loaded", (Object)trustStoreFileUrl.toString());
                    throw new RuntimeException(e);
                }
                catch (Exception e) {
                    LOGGER.errorf("Keystore %s entries can not be loaded", (Object)trustStoreFileUrl.toString());
                    throw new RuntimeException(e);
                }
            }
            fis.close();
        }
        return hashSet;
    }

    private static void addThumbprints(KeyStore keyStore, Set<String> allThumbprints, String alias) throws Exception {
        KeyStore.Entry entry = keyStore.getEntry(alias, null);
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            X509Certificate cert = (X509Certificate)((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate();
            allThumbprints.add(TrustStoreUtils.calculateThumprint(cert));
        }
    }

    public static String calculateThumprint(X509Certificate cert) {
        return X509Util.x5tS256(cert);
    }
}

