/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime.devui;

import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import java.time.Duration;
import java.util.function.Function;

@ApplicationScoped
public class OidcDevLoginObserver {
    private final BroadcastProcessor<Boolean> oidcLoginStream;

    OidcDevLoginObserver(OidcConfig config) {
        boolean isWebApplication = OidcTenantConfig.ApplicationType.WEB_APP == OidcConfig.getDefaultTenant(config).applicationType().orElse(null);
        this.oidcLoginStream = isWebApplication ? BroadcastProcessor.create() : null;
    }

    void observeOidcLogin(@Observes SecurityEvent event) {
        if (this.oidcLoginStream != null && event.getEventType() == SecurityEvent.Type.OIDC_LOGIN) {
            RoutingContext routingContext = (RoutingContext)event.getSecurityIdentity().getAttribute(RoutingContext.class.getName());
            if (routingContext != null && !routingContext.response().ended()) {
                routingContext.addEndHandler(new Handler<AsyncResult<Void>>(){

                    @Override
                    public void handle(AsyncResult<Void> voidAsyncResult) {
                        OidcDevLoginObserver.this.oidcLoginStream.onNext(true);
                    }
                });
            } else {
                this.oidcLoginStream.onNext(true);
            }
        }
    }

    Multi<Boolean> streamOidcLoginEvent() {
        return this.oidcLoginStream == null ? Multi.createFrom().empty() : this.oidcLoginStream.onItem().call(OidcDevLoginObserver.delayByOneSecond());
    }

    private static Function<Boolean, Uni<?>> delayByOneSecond() {
        return new Function<Boolean, Uni<?>>(){

            @Override
            public Uni<?> apply(Boolean i) {
                if (Boolean.TRUE.equals(i)) {
                    return Uni.createFrom().item(true).onItem().delayIt().by(Duration.ofSeconds(1L));
                }
                return Uni.createFrom().nothing();
            }
        };
    }
}

