/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime.providers;

import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.OidcTenantConfigBuilder;
import io.quarkus.oidc.common.runtime.config.OidcClientCommonConfig;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.oidc.runtime.builders.AuthenticationConfigBuilder;
import io.smallrye.jwt.algorithm.SignatureAlgorithm;

public class KnownOidcProviders {
    public static OidcTenantConfig provider(OidcTenantConfig.Provider provider) {
        return switch (provider) {
            default -> throw new IncompatibleClassChangeError();
            case OidcTenantConfig.Provider.APPLE -> KnownOidcProviders.apple();
            case OidcTenantConfig.Provider.DISCORD -> KnownOidcProviders.discord();
            case OidcTenantConfig.Provider.FACEBOOK -> KnownOidcProviders.facebook();
            case OidcTenantConfig.Provider.GITHUB -> KnownOidcProviders.github();
            case OidcTenantConfig.Provider.GOOGLE -> KnownOidcProviders.google();
            case OidcTenantConfig.Provider.LINKEDIN -> KnownOidcProviders.linkedIn();
            case OidcTenantConfig.Provider.MASTODON -> KnownOidcProviders.mastodon();
            case OidcTenantConfig.Provider.MICROSOFT -> KnownOidcProviders.microsoft();
            case OidcTenantConfig.Provider.SLACK -> KnownOidcProviders.slack();
            case OidcTenantConfig.Provider.SPOTIFY -> KnownOidcProviders.spotify();
            case OidcTenantConfig.Provider.STRAVA -> KnownOidcProviders.strava();
            case OidcTenantConfig.Provider.TWITCH -> KnownOidcProviders.twitch();
            case OidcTenantConfig.Provider.TWITTER, OidcTenantConfig.Provider.X -> KnownOidcProviders.twitter();
        };
    }

    private static OidcTenantConfig slack() {
        return OidcTenantConfig.authServerUrl("https://slack.com").applicationType(OidcTenantConfig.ApplicationType.WEB_APP).token("name").authentication().forceRedirectHttpsScheme().scopes("profile", "email").end().build();
    }

    private static OidcTenantConfig linkedIn() {
        return ((OidcTenantConfigBuilder)OidcTenantConfig.authServerUrl("https://www.linkedin.com/oauth").applicationType(OidcTenantConfig.ApplicationType.WEB_APP).authentication().scopes("email", "profile").end().token().principalClaim("name").end().credentials().clientSecret().method(OidcClientCommonConfig.Credentials.Secret.Method.POST).endCredentials()).build();
    }

    private static OidcTenantConfig github() {
        AuthenticationConfigBuilder authBuilder = new AuthenticationConfigBuilder();
        authBuilder.idTokenRequired(false);
        authBuilder.userInfoRequired();
        authBuilder.scopes("user:email");
        return ((OidcTenantConfigBuilder)((OidcTenantConfigBuilder)OidcTenantConfig.authServerUrl("https://github.com/login/oauth").applicationType(OidcTenantConfig.ApplicationType.WEB_APP).discoveryEnabled(false)).authorizationPath("authorize").tokenPath("access_token")).userInfoPath("https://api.github.com/user").token().verifyAccessTokenWithUserInfo(true).principalClaim("name").end().authentication(authBuilder.build()).build();
    }

    private static OidcTenantConfig twitter() {
        OidcTenantConfig.Authentication auth = new AuthenticationConfigBuilder().addOpenidScope(false).userInfoRequired().idTokenRequired(false).pkceRequired().scopes("offline.access", "tweet.read", "users.read").build();
        return ((OidcTenantConfigBuilder)((OidcTenantConfigBuilder)OidcTenantConfig.authServerUrl("https://api.twitter.com/2/oauth2").applicationType(OidcTenantConfig.ApplicationType.WEB_APP).discoveryEnabled(false)).authorizationPath("https://twitter.com/i/oauth2/authorize").tokenPath("token")).userInfoPath("https://api.twitter.com/2/users/me").authentication(auth).build();
    }

    private static OidcTenantConfig google() {
        return OidcTenantConfig.authServerUrl("https://accounts.google.com").applicationType(OidcTenantConfig.ApplicationType.WEB_APP).authentication().scopes("openid", "email", "profile").end().token().verifyAccessTokenWithUserInfo(true).principalClaim("name").end().build();
    }

    private static OidcTenantConfig mastodon() {
        OidcTenantConfig.Authentication auth = new AuthenticationConfigBuilder().addOpenidScope(false).userInfoRequired().idTokenRequired(false).scopes("read").build();
        return ((OidcTenantConfigBuilder)((OidcTenantConfigBuilder)OidcTenantConfig.authServerUrl("https://mastodon.social").discoveryEnabled(false)).applicationType(OidcTenantConfig.ApplicationType.WEB_APP).authorizationPath("/oauth/authorize").tokenPath("/oauth/token")).userInfoPath("/api/v1/accounts/verify_credentials").authentication(auth).build();
    }

    private static OidcTenantConfig microsoft() {
        return OidcTenantConfig.authServerUrl("https://login.microsoftonline.com/common/v2.0").applicationType(OidcTenantConfig.ApplicationType.WEB_APP).token().issuer("any").end().authentication().scopes("openid", "email", "profile").end().build();
    }

    private static OidcTenantConfig facebook() {
        return ((OidcTenantConfigBuilder)((OidcTenantConfigBuilder)OidcTenantConfig.authServerUrl("https://www.facebook.com").applicationType(OidcTenantConfig.ApplicationType.WEB_APP).discoveryEnabled(false)).authorizationPath("https://facebook.com/dialog/oauth/").tokenPath("https://graph.facebook.com/v12.0/oauth/access_token")).jwksPath("https://www.facebook.com/.well-known/oauth/openid/jwks/").authentication().scopes("email", "public_profile").forceRedirectHttpsScheme().end().build();
    }

    private static OidcTenantConfig apple() {
        OidcTenantConfigBuilder builder = OidcTenantConfig.authServerUrl("https://appleid.apple.com/").applicationType(OidcTenantConfig.ApplicationType.WEB_APP);
        builder.authentication().scopes("openid", "email", "name").forceRedirectHttpsScheme().responseMode(OidcTenantConfig.Authentication.ResponseMode.FORM_POST).end();
        builder.credentials().jwt().audience("https://appleid.apple.com/").signatureAlgorithm(SignatureAlgorithm.ES256.getAlgorithm()).end().clientSecret().method(OidcClientCommonConfig.Credentials.Secret.Method.POST_JWT).endCredentials();
        return builder.build();
    }

    private static OidcTenantConfig spotify() {
        OidcTenantConfig.Authentication authentication = new AuthenticationConfigBuilder().addOpenidScope(false).pkceRequired().idTokenRequired(false).scopes("user-read-private", "user-read-email").build();
        return ((OidcTenantConfigBuilder)((OidcTenantConfigBuilder)OidcTenantConfig.authServerUrl("https://accounts.spotify.com").discoveryEnabled(false)).applicationType(OidcTenantConfig.ApplicationType.WEB_APP).authorizationPath("authorize").tokenPath("api/token")).userInfoPath("https://api.spotify.com/v1/me").token().verifyAccessTokenWithUserInfo(true).principalClaim("display_name").end().authentication(authentication).build();
    }

    private static OidcTenantConfig strava() {
        OidcTenantConfigBuilder builder = ((OidcTenantConfigBuilder)((OidcTenantConfigBuilder)OidcTenantConfig.authServerUrl("https://www.strava.com/oauth").applicationType(OidcTenantConfig.ApplicationType.WEB_APP).discoveryEnabled(false)).authorizationPath("authorize").tokenPath("token")).token().verifyAccessTokenWithUserInfo(true).end().userInfoPath("https://www.strava.com/api/v3/athlete");
        builder.authentication().addOpenidScope(false).idTokenRequired(false).scopes("activity:read").redirectPath("/strava").scopeSeparator(",").end();
        builder.credentials().clientSecret().method(OidcClientCommonConfig.Credentials.Secret.Method.QUERY).endCredentials();
        return builder.build();
    }

    private static OidcTenantConfig twitch() {
        return ((OidcTenantConfigBuilder)OidcTenantConfig.authServerUrl("https://id.twitch.tv/oauth2").applicationType(OidcTenantConfig.ApplicationType.WEB_APP).authentication().forceRedirectHttpsScheme().end().credentials().clientSecret().method(OidcClientCommonConfig.Credentials.Secret.Method.POST).endCredentials()).build();
    }

    private static OidcTenantConfig discord() {
        return ((OidcTenantConfigBuilder)((OidcTenantConfigBuilder)OidcTenantConfig.authServerUrl("https://discord.com/api/oauth2").applicationType(OidcTenantConfig.ApplicationType.WEB_APP).discoveryEnabled(false)).authorizationPath("authorize").tokenPath("token")).jwksPath("keys").token().verifyAccessTokenWithUserInfo(true).end().authentication().scopes("identify", "email").idTokenRequired(false).end().userInfoPath("https://discord.com/api/users/@me").build();
    }
}

