/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime;

import io.quarkus.qute.runtime.QuteConfig;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URLConnection;
import org.jboss.logging.Logger;

@Singleton
public class ContentTypes {
    private static final Logger LOGGER = Logger.getLogger(ContentTypes.class);
    @Inject
    QuteConfig config;

    public String getContentType(String templatePath) {
        int dotIdx;
        String fileName = templatePath;
        int slashIdx = fileName.lastIndexOf(47);
        if (slashIdx != -1) {
            fileName = fileName.substring(slashIdx, fileName.length());
        }
        if ((dotIdx = fileName.lastIndexOf(46)) != -1) {
            String suffix = fileName.substring(dotIdx + 1, fileName.length());
            String additionalContentType = this.config.contentTypes.get(suffix);
            if (additionalContentType != null) {
                return additionalContentType;
            }
            if (suffix.equalsIgnoreCase("json")) {
                return "application/json";
            }
            String contentType = URLConnection.getFileNameMap().getContentTypeFor(fileName);
            if (contentType != null) {
                return contentType;
            }
        }
        LOGGER.warn("Unable to detect the content type for " + templatePath + "; using application/octet-stream");
        return "application/octet-stream";
    }
}

