/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

@Recorder
public class QuteRecorder {
    public Supplier<Object> createContext(final List<String> templatePaths, final List<String> tags, final Map<String, List<String>> variants, final Set<String> templateRoots, final Map<String, String> templateContents) {
        return new Supplier<Object>(){

            @Override
            public Object get() {
                return new QuteContext(){
                    volatile List<String> resolverClasses;
                    volatile List<String> templateGlobalProviderClasses;

                    @Override
                    public List<String> getTemplatePaths() {
                        return templatePaths;
                    }

                    @Override
                    public List<String> getTags() {
                        return tags;
                    }

                    @Override
                    public List<String> getResolverClasses() {
                        if (this.resolverClasses == null) {
                            throw this.generatedClassesNotInitialized();
                        }
                        return this.resolverClasses;
                    }

                    @Override
                    public Map<String, List<String>> getVariants() {
                        return variants;
                    }

                    @Override
                    public List<String> getTemplateGlobalProviderClasses() {
                        if (this.templateGlobalProviderClasses == null) {
                            throw this.generatedClassesNotInitialized();
                        }
                        return this.templateGlobalProviderClasses;
                    }

                    @Override
                    public Set<String> getTemplateRoots() {
                        return templateRoots;
                    }

                    @Override
                    public Map<String, String> getTemplateContents() {
                        return templateContents;
                    }

                    @Override
                    public void setGeneratedClasses(List<String> resolverClasses, List<String> templateGlobalProviderClasses) {
                        this.resolverClasses = resolverClasses;
                        this.templateGlobalProviderClasses = templateGlobalProviderClasses;
                    }

                    private IllegalStateException generatedClassesNotInitialized() {
                        return new IllegalStateException("Generated classes not initialized yet!");
                    }
                };
            }
        };
    }

    public void initializeGeneratedClasses(List<String> resolverClasses, List<String> templateGlobalProviderClasses) {
        QuteContext context = Arc.container().instance(QuteContext.class, new Annotation[0]).get();
        context.setGeneratedClasses(resolverClasses, templateGlobalProviderClasses);
    }

    public static interface QuteContext {
        public List<String> getResolverClasses();

        public List<String> getTemplatePaths();

        public List<String> getTags();

        public Map<String, List<String>> getVariants();

        public List<String> getTemplateGlobalProviderClasses();

        public Set<String> getTemplateRoots();

        public Map<String, String> getTemplateContents();

        public void setGeneratedClasses(List<String> var1, List<String> var2);
    }
}

