/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime.extensions;

import io.quarkus.qute.Results;
import io.quarkus.qute.TemplateExtension;
import jakarta.enterprise.inject.Vetoed;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;

@Vetoed
public class ConfigTemplateExtensions {
    static final String CONFIG = "config";

    @TemplateExtension(namespace="config", matchName="*")
    static Object getConfigProperty(String propertyName) {
        return ConfigTemplateExtensions.property(propertyName);
    }

    @TemplateExtension(namespace="config", priority=6)
    static Object property(String propertyName) {
        Optional<String> val = ConfigProvider.getConfig().getOptionalValue(propertyName, String.class);
        return val.isPresent() ? val.get() : Results.NotFound.from(propertyName);
    }

    @TemplateExtension(namespace="config", priority=7, matchName="boolean")
    static Object booleanProperty(String propertyName) {
        Optional<Boolean> val = ConfigProvider.getConfig().getOptionalValue(propertyName, Boolean.class);
        return val.isPresent() ? val.get() : Results.NotFound.from(propertyName);
    }

    @TemplateExtension(namespace="config", priority=7, matchName="integer")
    static Object integerProperty(String propertyName) {
        Optional<Integer> val = ConfigProvider.getConfig().getOptionalValue(propertyName, Integer.class);
        return val.isPresent() ? val.get() : Results.NotFound.from(propertyName);
    }
}

