/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.rest.client.reactive.jackson.runtime.serialisers.ResolverMapKey;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Providers;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;

final class JacksonUtil {
    static final ConcurrentMap<ResolverMapKey, ObjectMapper> contextResolverMap = new ConcurrentHashMap<ResolverMapKey, ObjectMapper>();

    private JacksonUtil() {
    }

    static ObjectMapper getObjectMapperFromContext(MediaType responseMediaType, RestClientRequestContext context) {
        Providers providers = JacksonUtil.getProviders(context);
        if (providers == null) {
            return null;
        }
        ContextResolver<ObjectMapper> contextResolver = providers.getContextResolver(ObjectMapper.class, responseMediaType);
        if (contextResolver == null) {
            contextResolver = providers.getContextResolver(ObjectMapper.class, null);
        }
        if (contextResolver != null) {
            final ContextResolver<ObjectMapper> cr = contextResolver;
            ResolverMapKey key = new ResolverMapKey(context.getConfiguration(), context.getInvokedMethod().getDeclaringClass());
            return contextResolverMap.computeIfAbsent(key, new Function<ResolverMapKey, ObjectMapper>(){

                @Override
                public ObjectMapper apply(ResolverMapKey resolverMapKey) {
                    return (ObjectMapper)cr.getContext(resolverMapKey.getRestClientClass());
                }
            });
        }
        return null;
    }

    private static Providers getProviders(RestClientRequestContext context) {
        if (context != null && context.getClientRequestContext() != null) {
            return context.getClientRequestContext().getProviders();
        }
        return null;
    }
}

