/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.runtime;

import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.core.MultivaluedMap;

public final class HeaderFillerUtil {
    private HeaderFillerUtil() {
    }

    public static boolean shouldAddHeader(String name, MultivaluedMap<String, String> headers, ClientRequestContext context) {
        String existingValue = headers.getFirst(name);
        if (existingValue == null) {
            return true;
        }
        if ("Content-Type".equals(name)) {
            Object defaultContentType = context.getProperty("io.quarkus.rest.client.defaultContentType");
            if (defaultContentType == null) {
                return true;
            }
            return existingValue.equals(defaultContentType);
        }
        if ("User-Agent".equals(name)) {
            return "Quarkus REST Client".equals(existingValue);
        }
        return false;
    }
}

