/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.rest.client.reactive.HeaderFiller;
import io.quarkus.rest.client.reactive.ReactiveClientHeadersFactory;
import io.quarkus.rest.client.reactive.runtime.ExtendedHeaderFiller;
import io.quarkus.rest.client.reactive.runtime.HeaderContainer;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.RequestScoped;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestFilter;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;

@Priority(value=-2147483648)
public class MicroProfileRestClientRequestFilter
implements ResteasyReactiveClientRequestFilter {
    private static final MultivaluedMap<String, String> EMPTY_MAP = new MultivaluedHashMap<String, String>();
    private final ClientHeadersFactory clientHeadersFactory;

    public MicroProfileRestClientRequestFilter(ClientHeadersFactory clientHeadersFactory) {
        this.clientHeadersFactory = clientHeadersFactory;
    }

    @Override
    public void filter(ResteasyReactiveClientRequestContext requestContext) {
        Object headerContainer;
        HeaderFiller headerFiller = (HeaderFiller)requestContext.getProperty(HeaderFiller.class.getName());
        MultivaluedHashMap<String, String> headers = new MultivaluedHashMap<String, String>();
        for (Map.Entry headerEntry : requestContext.getHeaders().entrySet()) {
            headers.put((String)headerEntry.getKey(), (String)((Object)MicroProfileRestClientRequestFilter.castToListOfStrings((Collection)headerEntry.getValue())));
        }
        if (headerFiller != null) {
            if (headerFiller instanceof ExtendedHeaderFiller) {
                ((ExtendedHeaderFiller)headerFiller).addHeaders(headers, requestContext);
            } else {
                headerFiller.addHeaders(headers);
            }
        }
        MultivaluedMap<String, String> incomingHeaders = EMPTY_MAP;
        if (Arc.container().getActiveContext(RequestScoped.class) != null && (headerContainer = Arc.container().instance(HeaderContainer.class, new Annotation[0]).get()) != null) {
            incomingHeaders = ((HeaderContainer)headerContainer).getHeaders();
        }
        for (Map.Entry entry : headers.entrySet()) {
            requestContext.getHeaders().put((String)entry.getKey(), MicroProfileRestClientRequestFilter.castToListOfObjects((List)entry.getValue()));
        }
        ClientHeadersFactory clientHeadersFactory = this.clientHeadersFactory(requestContext);
        if (clientHeadersFactory != null) {
            if (clientHeadersFactory instanceof ReactiveClientHeadersFactory) {
                ReactiveClientHeadersFactory reactiveClientHeadersFactory = (ReactiveClientHeadersFactory)clientHeadersFactory;
                requestContext.suspend();
                reactiveClientHeadersFactory.getHeaders(incomingHeaders, headers).subscribe().with(newHeaders -> {
                    for (Map.Entry headerEntry : newHeaders.entrySet()) {
                        requestContext.getHeaders().put((String)headerEntry.getKey(), MicroProfileRestClientRequestFilter.castToListOfObjects((List)headerEntry.getValue()));
                    }
                    requestContext.resume();
                }, requestContext::resume);
            } else {
                incomingHeaders = clientHeadersFactory.update(incomingHeaders, headers);
                for (Map.Entry headerEntry : incomingHeaders.entrySet()) {
                    requestContext.getHeaders().put((String)headerEntry.getKey(), MicroProfileRestClientRequestFilter.castToListOfObjects((List)headerEntry.getValue()));
                }
            }
        }
    }

    private ClientHeadersFactory clientHeadersFactory(ResteasyReactiveClientRequestContext requestContext) {
        ConfigurationImpl configuration;
        ClientHeadersFactory localHeadersFactory;
        if (requestContext.getConfiguration() instanceof ConfigurationImpl && (localHeadersFactory = (configuration = (ConfigurationImpl)requestContext.getConfiguration()).getFromContext(ClientHeadersFactory.class)) != null) {
            return localHeadersFactory;
        }
        return this.clientHeadersFactory;
    }

    private static List<String> castToListOfStrings(Collection<Object> values) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object value : values) {
            if (value instanceof String) {
                result.add((String)value);
                continue;
            }
            if (value instanceof Collection) {
                result.addAll(MicroProfileRestClientRequestFilter.castToListOfStrings((Collection)value));
                continue;
            }
            result.add(String.valueOf(value));
        }
        return result;
    }

    private static List<Object> castToListOfObjects(List<String> values) {
        return values;
    }
}

