/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.ConfigBuilder;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.SecretKeysHandler;
import io.smallrye.config.SecretKeysHandlerFactory;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;

public abstract class AbstractConfigBuilder
implements SmallRyeConfigBuilderCustomizer {
    protected static void withDefaultValue(SmallRyeConfigBuilder builder, String name, String value) {
        builder.withDefaultValue(name, value);
    }

    protected static <T> void withConverter(SmallRyeConfigBuilder builder, String type, int priority, Converter<T> converter) {
        try {
            builder.withConverter((Class)Class.forName(type, false, builder.getClassLoader()), priority, (Converter)converter);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void withInterceptor(SmallRyeConfigBuilder builder, ConfigSourceInterceptor interceptor) {
        builder.withInterceptors(interceptor);
    }

    protected static void withInterceptorFactory(SmallRyeConfigBuilder builder, ConfigSourceInterceptorFactory interceptorFactory) {
        builder.withInterceptorFactories(interceptorFactory);
    }

    protected static void withSource(SmallRyeConfigBuilder builder, ConfigSource configSource) {
        builder.withSources(configSource);
    }

    protected static void withSource(SmallRyeConfigBuilder builder, ConfigSourceProvider configSourceProvider) {
        builder.withSources(configSourceProvider);
    }

    protected static void withSource(SmallRyeConfigBuilder builder, ConfigSourceFactory configSourceFactory) {
        builder.withSources(configSourceFactory);
    }

    protected static void withSecretKeyHandler(SmallRyeConfigBuilder builder, SecretKeysHandler secretKeysHandler) {
        builder.withSecretKeysHandlers(secretKeysHandler);
    }

    protected static void withSecretKeyHandler(SmallRyeConfigBuilder builder, SecretKeysHandlerFactory secretKeysHandlerFactory) {
        builder.withSecretKeyHandlerFactories(secretKeysHandlerFactory);
    }

    protected static void withMapping(SmallRyeConfigBuilder builder, String mappingClass, String prefix) {
        try {
            builder.withMapping(builder.getClassLoader().loadClass(mappingClass), prefix);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void withBuilder(SmallRyeConfigBuilder builder, final ConfigBuilder configBuilder) {
        builder.withCustomizers(new SmallRyeConfigBuilderCustomizer(){

            @Override
            public void configBuilder(SmallRyeConfigBuilder builder) {
                configBuilder.configBuilder(builder);
            }

            @Override
            public int priority() {
                return configBuilder.priority();
            }
        });
    }

    protected static void withCustomizer(SmallRyeConfigBuilder builder, SmallRyeConfigBuilderCustomizer customizer) {
        builder.withCustomizers(customizer);
    }

    public static void withCustomizer(SmallRyeConfigBuilder builder, String customizer) {
        try {
            Class<?> customizerClass = builder.getClassLoader().loadClass(customizer);
            ((SmallRyeConfigBuilderCustomizer)customizerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).configBuilder(builder);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

