/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.QuarkusConfigBuilderCustomizer;
import io.quarkus.runtime.configuration.RuntimeOverrideConfigSource;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;

public final class ConfigUtils {
    static final String UUID_KEY = "quarkus.uuid";

    private ConfigUtils() {
    }

    public static <T> IntFunction<List<T>> listFactory() {
        return ArrayList::new;
    }

    public static <T> IntFunction<Set<T>> setFactory() {
        return LinkedHashSet::new;
    }

    public static <T> IntFunction<SortedSet<T>> sortedSetFactory() {
        return size -> new TreeSet();
    }

    public static SmallRyeConfigBuilder configBuilder(boolean runTime, LaunchMode launchMode) {
        return ConfigUtils.configBuilder(runTime, true, launchMode);
    }

    public static SmallRyeConfigBuilder configBuilder(boolean runTime, boolean addDiscovered, LaunchMode launchMode) {
        SmallRyeConfigBuilder builder = ConfigUtils.emptyConfigBuilder();
        if (launchMode.isDevOrTest() && runTime) {
            builder.withSources(new RuntimeOverrideConfigSource(builder.getClassLoader()));
        }
        if (runTime) {
            builder.withDefaultValue(UUID_KEY, UUID.randomUUID().toString());
        }
        if (addDiscovered) {
            builder.addDiscoveredCustomizers().addDiscoveredSources();
        }
        return builder;
    }

    public static SmallRyeConfigBuilder emptyConfigBuilder() {
        return new SmallRyeConfigBuilder().forClassLoader(Thread.currentThread().getContextClassLoader()).withCustomizers(new QuarkusConfigBuilderCustomizer()).addDiscoveredConverters().addDefaultInterceptors().addDiscoveredInterceptors().addDiscoveredSecretKeysHandlers().addDefaultSources();
    }

    public static List<String> getProfiles() {
        return ConfigProvider.getConfig().unwrap(SmallRyeConfig.class).getProfiles();
    }

    public static boolean isProfileActive(String profile) {
        return ConfigUtils.getProfiles().contains(profile);
    }

    public static boolean isPropertyPresent(String propertyName) {
        return ConfigProvider.getConfig().unwrap(SmallRyeConfig.class).isPropertyPresent(propertyName);
    }

    public static boolean isPropertyNonEmpty(String propertyName) {
        ConfigValue configValue = ConfigProvider.getConfig().getConfigValue(propertyName);
        return configValue.getValue() != null && !configValue.getValue().isEmpty();
    }

    public static boolean isAnyPropertyPresent(Collection<String> propertyNames) {
        for (String propertyName : propertyNames) {
            if (!ConfigUtils.isPropertyPresent(propertyName)) continue;
            return true;
        }
        return false;
    }

    public static <T> Optional<T> getFirstOptionalValue(List<String> propertyNames, Class<T> propertyType) {
        Config config = ConfigProvider.getConfig();
        for (String propertyName : propertyNames) {
            Optional<T> value = config.getOptionalValue(propertyName, propertyType);
            if (!value.isPresent()) continue;
            return value;
        }
        return Optional.empty();
    }
}

