/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.QuarkusConfigBuilderCustomizer;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import java.util.Set;
import java.util.UUID;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class RuntimeConfigBuilder
implements SmallRyeConfigBuilderCustomizer {
    @Override
    public void configBuilder(SmallRyeConfigBuilder builder) {
        new QuarkusConfigBuilderCustomizer().configBuilder(builder);
        builder.withSources(new UuidConfigSource());
        builder.forClassLoader(Thread.currentThread().getContextClassLoader()).addDefaultInterceptors().addDefaultSources();
    }

    @Override
    public int priority() {
        return Integer.MIN_VALUE;
    }

    private static class UuidConfigSource
    implements ConfigSource {
        private static final String QUARKUS_UUID = "quarkus.uuid";

        private UuidConfigSource() {
        }

        @Override
        public Set<String> getPropertyNames() {
            return Set.of();
        }

        @Override
        public String getValue(String propertyName) {
            if (propertyName.equals(QUARKUS_UUID)) {
                return Holder.UUID_VALUE;
            }
            return null;
        }

        @Override
        public String getName() {
            return "QuarkusUUIDConfigSource";
        }

        @Override
        public int getOrdinal() {
            return Integer.MIN_VALUE;
        }

        private static class Holder {
            private static final String UUID_VALUE = UUID.randomUUID().toString();

            private Holder() {
            }
        }
    }
}

