/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.arc.DefaultBean;
import io.quarkus.runtime.ExecutorRecorder;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.runtime.AnonymousIdentityProvider;
import io.quarkus.security.runtime.QuarkusIdentityProviderManagerImpl;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class IdentityProviderManagerCreator {
    @ApplicationScoped
    @DefaultBean
    @Produces
    BlockingSecurityExecutor defaultBlockingExecutor() {
        return BlockingSecurityExecutor.createBlockingExecutor(new Supplier<Executor>(){

            @Override
            public Executor get() {
                return ExecutorRecorder.getCurrent();
            }
        });
    }

    @Produces
    @ApplicationScoped
    public IdentityProviderManager ipm(Instance<IdentityProvider<?>> identityProviders, Instance<SecurityIdentityAugmentor> augmentors, BlockingSecurityExecutor blockingExecutor) {
        boolean customAnon = false;
        QuarkusIdentityProviderManagerImpl.Builder builder = QuarkusIdentityProviderManagerImpl.builder();
        for (IdentityProvider identityProvider : identityProviders) {
            builder.addProvider(identityProvider);
            if (identityProvider.getRequestType() != AnonymousAuthenticationRequest.class) continue;
            customAnon = true;
        }
        if (!customAnon) {
            builder.addProvider(new AnonymousIdentityProvider());
        }
        for (SecurityIdentityAugmentor securityIdentityAugmentor : augmentors) {
            builder.addSecurityIdentityAugmentor(securityIdentityAugmentor);
        }
        builder.setBlockingExecutor(blockingExecutor);
        return builder.build();
    }
}

