/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.smallrye.mutiny.Uni;
import java.lang.annotation.Annotation;
import java.security.Permission;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class QuarkusPermission<T>
extends Permission {
    private volatile InstanceHandle<T> bean = null;

    protected QuarkusPermission(String permissionName) {
        super(permissionName);
    }

    protected abstract Class<T> getBeanClass();

    protected abstract boolean isBlocking();

    protected abstract boolean isReactive();

    protected final T getBean() {
        return this.getBeanInstanceHandle().get();
    }

    protected abstract boolean isGranted(SecurityIdentity var1);

    protected abstract Uni<Boolean> isGrantedUni(SecurityIdentity var1);

    final Uni<Boolean> isGranted(final SecurityIdentity identity, BlockingSecurityExecutor blockingExecutor) {
        if (this.isBlocking()) {
            return blockingExecutor.executeBlocking(new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return QuarkusPermission.this.isGranted(identity);
                }
            });
        }
        try {
            if (this.isReactive()) {
                return this.isGrantedUni(identity);
            }
            return Uni.createFrom().item(this.isGranted(identity));
        }
        catch (Throwable throwable) {
            return Uni.createFrom().failure(throwable);
        }
    }

    @Override
    public final boolean implies(Permission requiredPermission) {
        throw new IllegalStateException("QuarkusPermission should never be assigned to a SecurityIdentity. This permission can only be set to the @PermissionsAllowed#permission attribute by Quarkus itself.");
    }

    @Override
    public final String getActions() {
        return "";
    }

    @Override
    public final boolean equals(Object object) {
        return this == object;
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.toString());
    }

    private InstanceHandle<T> getBeanInstanceHandle() {
        if (this.bean == null) {
            this.bean = Arc.container().instance(this.getBeanClass(), new Annotation[0]);
            if (!this.bean.isAvailable()) {
                throw new IllegalStateException("CDI bean '%s' is not available, but it is required by the @PermissionChecker method".formatted(this.getBeanClass()));
            }
        }
        return this.bean;
    }

    protected static Uni<Boolean> accessDenied() {
        return Uni.createFrom().item(false);
    }
}

